/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mindfuldarkness.client.handler;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.mindfuldarkness.mixin.client.accessor.TextureManagerAccessor;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.resources.ResourceLocation;

public class ColorChangedAssetsManager {
    public static final ColorChangedAssetsManager INSTANCE = new ColorChangedAssetsManager();
    private final Set<ResourceLocation> colorChangingTextures = Sets.newHashSet();

    public void add(ResourceLocation path) {
        this.colorChangingTextures.add(path);
    }

    private void reset() {
        TextureManager textureManager = Minecraft.m_91087_().m_91097_();
        if (textureManager == null) {
            return;
        }
        Map<ResourceLocation, AbstractTexture> byPath = ((TextureManagerAccessor)textureManager).mindfuldarkness$getByPath();
        Set<Tickable> tickableTextures = ((TextureManagerAccessor)textureManager).mindfuldarkness$getTickableTextures();
        for (ResourceLocation path : this.colorChangingTextures) {
            AbstractTexture abstractTexture = byPath.remove(path);
            if (abstractTexture == null) continue;
            ((TextureManagerAccessor)textureManager).mindfuldarkness$callSafeClose(path, abstractTexture);
            if (!(abstractTexture instanceof Tickable)) continue;
            tickableTextures.remove(abstractTexture);
        }
        this.colorChangingTextures.clear();
    }

    public void recordedReset() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(this::reset);
        } else {
            this.reset();
        }
    }
}

