/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.particles.laserparticle;

import com.direwolf20.mininggadgets.client.particles.laserparticle.LaserParticleData;
import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.tiles.RenderBlockTileEntity;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.BreakingItemParticle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class LaserParticle
extends BreakingItemParticle {
    private float f;
    private float f1;
    private float f2;
    private float f3;
    private float f4;
    private float f5;
    private BlockState blockState;
    private UUID playerUUID;
    private double sourceX;
    private double sourceY;
    private double sourceZ;
    private int speedModifier;
    private boolean voiding = false;
    private float originalSize;
    public static ParticleProvider<LaserParticleData> FACTORY = (data, world, x, y, z, xSpeed, ySpeed, zSpeed) -> new LaserParticle(world, x, y, z, xSpeed, ySpeed, zSpeed, data.size, data.r, data.g, data.b, data.depthTest, data.maxAgeMul, data.state);
    private boolean depthTest;
    private final float moteParticleScale;
    private final int moteHalfLife;

    public LaserParticle(ClientLevel world, double d, double d1, double d2, double xSpeed, double ySpeed, double zSpeed, float size, float red, float green, float blue, boolean depthTest, float maxAgeMul, BlockState blockState) {
        this(world, d, d1, d2, xSpeed, ySpeed, zSpeed, size, red, green, blue, depthTest, maxAgeMul);
        this.blockState = blockState;
        this.m_108337_(Minecraft.m_91087_().m_91289_().m_110907_().m_110882_(blockState));
    }

    public LaserParticle(ClientLevel world, double d, double d1, double d2, double xSpeed, double ySpeed, double zSpeed, float size, float red, float green, float blue, boolean depthTest, float maxAgeMul) {
        super(world, d, d1, d2, ItemStack.f_41583_);
        this.f_107215_ = xSpeed;
        this.f_107216_ = ySpeed;
        this.f_107217_ = zSpeed;
        this.f_107227_ = red;
        this.f_107228_ = green;
        this.f_107229_ = blue;
        this.f_107226_ = 0.0f;
        this.f_107663_ *= size;
        this.originalSize = this.f_107663_;
        this.moteParticleScale = this.f_107663_;
        this.f_107225_ = Math.round(maxAgeMul);
        this.depthTest = depthTest;
        this.moteHalfLife = this.f_107225_ / 2;
        this.m_107250_(0.001f, 0.001f);
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        RenderBlockTileEntity te = (RenderBlockTileEntity)world.m_7702_(new BlockPos(this.f_107212_, this.f_107213_, this.f_107214_));
        if (te != null) {
            this.playerUUID = te.getPlayerUUID();
            this.voiding = !te.getBlockAllowed();
        }
        this.sourceX = d;
        this.sourceY = d1;
        this.sourceZ = d2;
        this.f_107219_ = false;
    }

    public void m_5744_(VertexConsumer builder, Camera activeRenderInfo, float partialTicks) {
        super.m_5744_(builder, activeRenderInfo, partialTicks);
    }

    public boolean particleToPlayer(Player player) {
        BlockEntity te;
        boolean partToPlayer = false;
        BlockPos sourcePos = new BlockPos(this.sourceX, this.sourceY, this.sourceZ);
        if (this.f_107208_.m_8055_(sourcePos) != this.blockState) {
            partToPlayer = true;
        }
        if ((te = this.f_107208_.m_7702_(sourcePos)) != null && te instanceof RenderBlockTileEntity && ((RenderBlockTileEntity)te).getTicksSinceMine() >= 5) {
            partToPlayer = false;
        }
        return partToPlayer;
    }

    public void m_5989_() {
        double moveZ;
        double moveY;
        double moveX;
        if (this.playerUUID == null) {
            this.m_107274_();
            return;
        }
        Player player = this.f_107208_.m_46003_(this.playerUUID);
        if (player == null) {
            this.m_107274_();
            return;
        }
        Vec3 playerPos = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
        Vec3 blockPos = new Vec3(this.sourceX, this.sourceY, this.sourceZ);
        Vec3 look = player.m_20154_();
        Vec3 right = new Vec3(-look.f_82481_, 0.0, look.f_82479_).m_82541_();
        Vec3 forward = look;
        Vec3 down = right.m_82537_(forward);
        right = right.m_82490_((double)0.65f);
        forward = forward.m_82490_((double)0.85f);
        down = down.m_82490_(-0.35);
        Vec3 laserPos = playerPos.m_82549_(right);
        laserPos = laserPos.m_82549_(forward);
        laserPos = laserPos.m_82549_(down);
        Vec3 partPos = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        Vec3 targetDirection = new Vec3(laserPos.m_7096_() - this.f_107212_, laserPos.m_7098_() - this.f_107213_, laserPos.m_7094_() - this.f_107214_);
        double totalDistance = blockPos.m_82554_(laserPos);
        if (this.particleToPlayer(player)) {
            ++this.speedModifier;
            speedAdjust = 30 - this.speedModifier <= 0 ? 1 : 30 - this.speedModifier;
            double distance = laserPos.m_82554_(partPos);
            if (distance < 0.25) {
                this.m_107274_();
            }
            if (this.f_107224_ > 5) {
                float spinSpeed = Mth.m_14179_((float)(1.0f - (float)distance / (float)totalDistance), (float)1.1f, (float)0.05f);
                targetDirection = targetDirection.m_82549_(targetDirection.m_82537_(look).m_82490_((double)spinSpeed).m_82542_(3.0, 3.0, 3.0));
            }
            this.f_107663_ *= Mth.m_14179_((float)(1.0f - (float)distance / (float)totalDistance), (float)1.05f, (float)0.85f);
            moveX = targetDirection.m_7096_() / (double)speedAdjust;
            moveY = targetDirection.m_7098_() / (double)speedAdjust;
            moveZ = targetDirection.m_7094_() / (double)speedAdjust;
            ItemStack heldItem = MiningGadget.getGadget(player);
            if (heldItem.m_41720_() instanceof MiningGadget && MiningProperties.getRange(heldItem) > 1 && this.f_107224_ < 5) {
                int compressionFactor = 7;
                moveX *= (1.0 - Math.abs(look.f_82479_)) * (double)compressionFactor;
                moveY *= (1.0 - Math.abs(look.f_82480_)) * (double)compressionFactor;
                moveZ *= (1.0 - Math.abs(look.f_82481_)) * (double)compressionFactor;
            }
        } else {
            this.speedModifier = 0;
            speedAdjust = 20 - this.speedModifier <= 0 ? 1 : 20 - this.speedModifier;
            double distance = blockPos.m_82554_(partPos);
            if (distance < 0.75) {
                this.m_107274_();
            }
            moveX = (this.sourceX - this.f_107212_) / (double)speedAdjust;
            moveY = (this.sourceY - this.f_107213_) / (double)speedAdjust;
            moveZ = (this.sourceZ - this.f_107214_) / (double)speedAdjust;
        }
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.voiding && this.f_107224_ > 10 && this.f_107224_ <= 15) {
            float darkness;
            this.f_107227_ = darkness = Mth.m_14179_((float)((float)(this.f_107224_ - 10) / 5.0f), (float)1.0f, (float)0.0f);
            this.f_107228_ = darkness;
            this.f_107229_ = darkness;
        }
        if (this.voiding && this.f_107224_ > 15 && this.f_107224_ <= 25) {
            float fade = Mth.m_14179_((float)(((float)this.f_107224_ - 15.0f) / 10.0f), (float)1.0f, (float)0.0f);
            this.f_107663_ = this.originalSize * fade;
        }
        this.m_6257_(moveX, moveY, moveZ);
    }

    public void setGravity(float value) {
        this.f_107226_ = value;
    }

    public void setSpeed(float mx, float my, float mz) {
        this.f_107215_ = mx;
        this.f_107216_ = my;
        this.f_107217_ = mz;
    }
}

