/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.renderer;

import com.direwolf20.mininggadgets.client.renderer.MyRenderType;
import com.direwolf20.mininggadgets.common.blocks.RenderBlock;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.tiles.RenderBlockTileEntity;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class RenderBlockTER
implements BlockEntityRenderer<RenderBlockTileEntity> {
    public RenderBlockTER(BlockEntityRendererProvider.Context p_173636_) {
    }

    private void renderModelBrightnessColorQuads(PoseStack.Pose matrixEntry, VertexConsumer builder, float red, float green, float blue, float alpha, List<BakedQuad> listQuads, int combinedLightsIn, int combinedOverlayIn) {
        for (BakedQuad bakedquad : listQuads) {
            float f2;
            float f1;
            float f;
            if (bakedquad.m_111304_()) {
                f = red * 1.0f;
                f1 = green * 1.0f;
                f2 = blue * 1.0f;
            } else {
                f = 1.0f;
                f1 = 1.0f;
                f2 = 1.0f;
            }
            builder.putBulkData(matrixEntry, bakedquad, f, f1, f2, alpha, combinedLightsIn, combinedOverlayIn);
        }
    }

    public void render(RenderBlockTileEntity tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightsIn, int combinedOverlayIn) {
        BlockState renderState;
        float nowScale;
        int durability = tile.getDurability();
        int originalDurability = tile.getOriginalDurability();
        int prevDurability = tile.getPriorDurability();
        float prevScale = (float)prevDurability / (float)originalDurability;
        float scale = Mth.m_14179_((float)partialTicks, (float)prevScale, (float)(nowScale = (float)durability / (float)originalDurability));
        if (scale >= 1.0f) {
            scale = 1.0f;
        }
        if (scale <= 0.0f) {
            scale = 0.0f;
        }
        if ((renderState = tile.getRenderBlock()) == null) {
            return;
        }
        BlockRenderDispatcher blockrendererdispatcher = Minecraft.m_91087_().m_91289_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        MiningProperties.BreakTypes breakType = tile.getBreakType();
        BakedModel ibakedmodel = blockrendererdispatcher.m_110910_(renderState);
        BlockColors blockColors = Minecraft.m_91087_().m_91298_();
        int color = blockColors.m_92577_(renderState, (BlockAndTintGetter)tile.m_58904_(), tile.m_58899_(), 0);
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        matrixStackIn.m_85836_();
        if (breakType == MiningProperties.BreakTypes.SHRINK) {
            matrixStackIn.m_85837_((double)((1.0f - scale) / 2.0f), (double)((1.0f - scale) / 2.0f), (double)((1.0f - scale) / 2.0f));
            matrixStackIn.m_85841_(scale, scale, scale);
            VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110463_());
            for (Direction direction : Direction.values()) {
                this.renderModelBrightnessColorQuads(matrixStackIn.m_85850_(), builder, f, f1, f2, 1.0f, this.getQuads(ibakedmodel, tile, direction), combinedLightsIn, combinedOverlayIn);
            }
            this.renderModelBrightnessColorQuads(matrixStackIn.m_85850_(), builder, f, f1, f2, 1.0f, this.getQuads(ibakedmodel, tile, null), combinedLightsIn, combinedOverlayIn);
        } else if (breakType == MiningProperties.BreakTypes.FADE) {
            scale = Mth.m_14179_((float)scale, (float)0.1f, (float)1.0f);
            VertexConsumer builder = bufferIn.m_6299_(MyRenderType.RenderBlock);
            for (Direction direction : Direction.values()) {
                if (tile.m_58904_().m_8055_(tile.m_58899_().m_121945_(direction)).m_60734_() instanceof RenderBlock) continue;
                this.renderModelBrightnessColorQuads(matrixStackIn.m_85850_(), builder, f, f1, f2, scale, this.getQuads(ibakedmodel, tile, direction), combinedLightsIn, combinedOverlayIn);
            }
            this.renderModelBrightnessColorQuads(matrixStackIn.m_85850_(), builder, f, f1, f2, scale, this.getQuads(ibakedmodel, tile, null), combinedLightsIn, combinedOverlayIn);
        }
        matrixStackIn.m_85849_();
    }

    private List<BakedQuad> getQuads(BakedModel model, RenderBlockTileEntity tile, Direction side) {
        return model.getQuads(tile.getRenderBlock(), side, RandomSource.m_216335_((long)Mth.m_14057_((Vec3i)tile.m_58899_())), (IModelData)EmptyModelData.INSTANCE);
    }
}

