/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.renderer;

import com.direwolf20.mininggadgets.common.blocks.ModBlocks;
import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.common.items.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.items.upgrade.UpgradeTools;
import com.direwolf20.mininggadgets.common.tiles.ModificationTableTileEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;

public class ModificationShiftOverlay {
    public static void render(RenderLevelStageEvent evt, Player player) {
        HitResult pick = player.m_19907_(5.0, 0.0f, false);
        if (pick.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult trace = (BlockHitResult)pick;
        if (player.f_19853_.m_8055_(trace.m_82425_()).m_60734_() != ModBlocks.MODIFICATION_TABLE.get()) {
            return;
        }
        BlockEntity blockEntity = player.f_19853_.m_7702_(trace.m_82425_());
        if (!(blockEntity instanceof ModificationTableTileEntity)) {
            return;
        }
        ItemStack stack = ((ModificationTableTileEntity)blockEntity).handler.map(e -> e.getStackInSlot(0)).orElse(ItemStack.f_41583_);
        if (stack.m_41619_() || !(stack.m_41720_() instanceof MiningGadget)) {
            return;
        }
        List<Upgrade> upgrades = UpgradeTools.getUpgrades(stack);
        if (upgrades.isEmpty()) {
            return;
        }
        Vec3 view = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        BlockPos blockPos = ((BlockHitResult)pick).m_82425_();
        double distance = player.m_20318_(evt.getPartialTick()).m_82554_(new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()));
        float scaleFactor = Math.max(0.2f, (float)distance / 10.0f + 0.1f);
        PoseStack matrix = evt.getPoseStack();
        matrix.m_85836_();
        matrix.m_85837_(-view.f_82479_, -view.f_82480_, -view.f_82481_);
        matrix.m_252880_((float)blockPos.m_123341_() + 0.5f, (float)(blockPos.m_123342_() + 1), (float)blockPos.m_123343_() + 0.5f);
        matrix.m_85841_(scaleFactor, scaleFactor, scaleFactor);
        matrix.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
        MultiBufferSource.BufferSource outlineLayerBuffer = Minecraft.m_91087_().m_91269_().m_110104_();
        int x = 0;
        int y = 0;
        float offset = upgrades.size() / 3 > 0 ? -1.15f : (upgrades.size() > 1 ? -((float)upgrades.size() / 3.0f) : -0.2f);
        for (Upgrade upgrade : upgrades) {
            matrix.m_85836_();
            matrix.m_252880_(offset + (float)x, (float)y, 0.0f);
            matrix.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            matrix.m_252781_(Axis.f_252529_.m_252977_(26.0f));
            ItemStack upgradeStack = new ItemStack((ItemLike)upgrade.getCardItem().get());
            BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(upgradeStack, (Level)Minecraft.m_91087_().f_91073_, null, 0);
            Minecraft.m_91087_().m_91291_().m_115143_(upgradeStack, ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND, false, matrix, (MultiBufferSource)outlineLayerBuffer, 0xF000F0, OverlayTexture.f_118083_, model);
            if (++x > 2) {
                x = 0;
                ++y;
            }
            matrix.m_85849_();
        }
        outlineLayerBuffer.m_109911_();
        matrix.m_85849_();
    }
}

