/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.blocks;

import com.direwolf20.mininggadgets.common.blocks.ModBlocks;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkHooks;

public class ModificationTable
extends Block
implements EntityBlock {
    public static DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public ModificationTable() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(2.0f));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shape.getFromFacing((Direction)state.m_61143_((Property)FACING));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return ((BlockEntityType)ModBlocks.MODIFICATIONTABLE_TILE.get()).m_155264_(p_153215_, p_153216_);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!world.f_46443_) {
            BlockEntity tileEntity = world.m_7702_(pos);
            if (!(tileEntity instanceof MenuProvider)) {
                throw new IllegalStateException("Our named container provider is missing!");
            }
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((MenuProvider)tileEntity), (BlockPos)tileEntity.m_58899_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.m_60734_() != this) {
            BlockEntity tileEntity = worldIn.m_7702_(pos);
            if (tileEntity != null) {
                LazyOptional cap = tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER);
                cap.ifPresent(handler -> {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)handler.getStackInSlot(i));
                    }
                });
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    private static enum Shape {
        NORTH(Stream.of(Block.m_49796_((double)2.0, (double)11.0, (double)12.0, (double)14.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)1.0, (double)10.0, (double)1.0, (double)15.0, (double)11.0, (double)9.0), Block.m_49796_((double)0.0, (double)10.0, (double)11.0, (double)16.0, (double)11.0, (double)16.0), Block.m_49796_((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)12.0, (double)10.0), Block.m_49796_((double)13.0, (double)12.0, (double)2.0, (double)14.0, (double)13.0, (double)8.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get()),
        EAST(Stream.of(Block.m_49796_((double)0.0, (double)11.0, (double)2.0, (double)4.0, (double)16.0, (double)14.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)7.0, (double)10.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0), Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0), Block.m_49796_((double)6.0, (double)11.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)8.0, (double)12.0, (double)13.0, (double)14.0, (double)13.0, (double)14.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get()),
        SOUTH(Stream.of(Block.m_49796_((double)2.0, (double)11.0, (double)0.0, (double)14.0, (double)16.0, (double)4.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)1.0, (double)10.0, (double)7.0, (double)15.0, (double)11.0, (double)15.0), Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)11.0, (double)5.0), Block.m_49796_((double)0.0, (double)11.0, (double)6.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)2.0, (double)12.0, (double)8.0, (double)3.0, (double)13.0, (double)14.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get()),
        WEST(Stream.of(Block.m_49796_((double)12.0, (double)11.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)1.0, (double)10.0, (double)1.0, (double)9.0, (double)11.0, (double)15.0), Block.m_49796_((double)11.0, (double)10.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), Block.m_49796_((double)0.0, (double)11.0, (double)0.0, (double)10.0, (double)12.0, (double)16.0), Block.m_49796_((double)2.0, (double)12.0, (double)2.0, (double)8.0, (double)13.0, (double)3.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get());

        private final VoxelShape shape;

        private Shape(VoxelShape shape) {
            this.shape = shape;
        }

        public static VoxelShape getFromFacing(Direction facing) {
            return switch (facing) {
                case Direction.NORTH -> Shape.NORTH.shape;
                case Direction.EAST -> Shape.EAST.shape;
                case Direction.SOUTH -> Shape.SOUTH.shape;
                case Direction.WEST -> Shape.WEST.shape;
                default -> throw new IllegalStateException("Invalid facing");
            };
        }
    }
}

