/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client;

import com.direwolf20.mininggadgets.client.screens.ModificationTableScreen;
import com.direwolf20.mininggadgets.common.Config;
import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.common.items.ModItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

@JeiPlugin
public class MiningGadgetsJEI
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("mininggadgets", "jei_plugin");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        IIngredientSubtypeInterpreter chargedProvider = (stack, uid) -> {
            if (!(stack.m_41720_() instanceof MiningGadget)) {
                return "";
            }
            double energy = stack.m_41784_().m_128459_("energy");
            if (energy == 0.0) {
                return "empty";
            }
            if (energy == (double)((Integer)Config.MININGGADGET_MAXPOWER.get()).intValue()) {
                return "charged";
            }
            return "";
        };
        registration.registerSubtypeInterpreter((Item)ModItems.MININGGADGET.get(), chargedProvider);
        registration.registerSubtypeInterpreter((Item)ModItems.MININGGADGET_SIMPLE.get(), chargedProvider);
        registration.registerSubtypeInterpreter((Item)ModItems.MININGGADGET_FANCY.get(), chargedProvider);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(ModificationTableScreen.class, (IGuiContainerHandler)new ModificationTableContainerHandler());
    }

    private static class ModificationTableContainerHandler
    implements IGuiContainerHandler<ModificationTableScreen> {
        private ModificationTableContainerHandler() {
        }

        public List<Rect2i> getGuiExtraAreas(ModificationTableScreen containerScreen) {
            return new ArrayList<Rect2i>(Collections.singleton(new Rect2i(containerScreen.f_96543_ / 2 - 120, containerScreen.f_96544_ / 2 - 5, 25, 35)));
        }
    }
}

