/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.screens;

import com.direwolf20.mininggadgets.common.containers.ModificationTableContainer;
import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.common.items.UpgradeCard;
import com.direwolf20.mininggadgets.common.items.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.items.upgrade.UpgradeTools;
import com.direwolf20.mininggadgets.common.network.PacketHandler;
import com.direwolf20.mininggadgets.common.network.packets.PacketExtractUpgrade;
import com.direwolf20.mininggadgets.common.network.packets.PacketInsertUpgrade;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.gui.ScrollPanel;
import net.minecraftforge.fmllegacy.ForgeI18n;

public class ModificationTableScreen
extends AbstractContainerScreen<ModificationTableContainer> {
    private ResourceLocation GUI = new ResourceLocation("mininggadgets", "textures/gui/modificationtable.png");
    private BlockPos tePos;
    private ModificationTableContainer container;
    private Inventory playerInventory;
    private ScrollingUpgrades scrollingUpgrades;

    public ModificationTableScreen(ModificationTableContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.tePos = container.getTE().m_58899_();
        this.container = container;
        this.playerInventory = inv;
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.scrollingUpgrades.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.m_7025_(stack, mouseX, mouseY);
        int relX = this.f_96543_ / 2;
        int relY = this.f_96544_ / 2;
        ModificationTableScreen.m_93208_((PoseStack)stack, (Font)this.f_96547_, (String)ForgeI18n.getPattern((String)String.format("%s.%s", "mininggadgets", "text.modification_table")), (int)relX, (int)(relY - 100), (int)0xFFFFFF);
        if (this.container.getUpgradesCache().size() == 0) {
            String string = ForgeI18n.getPattern((String)String.format("%s.%s", "mininggadgets", "text.empty_table_helper"));
            String[] parts = string.split("\n");
            for (int i = 0; i < parts.length; ++i) {
                int n = relX + 17 - this.f_96547_.m_92895_(parts[0]) / 2;
                Objects.requireNonNull(this.f_96547_);
                this.drawScaledCenteredString(stack, n, relY - 68 + i * 9, 0.8f, parts[i], 0xFFFFFF);
            }
        }
    }

    protected void m_7027_(PoseStack stack, int mouseX, int mouseY) {
    }

    private void drawScaledCenteredString(PoseStack matrices, int x, int y, float scale, String textComponent, int color) {
        matrices.m_85836_();
        matrices.m_85837_((double)x, (double)y, 0.0);
        matrices.m_85841_(scale, scale, scale);
        ModificationTableScreen.m_93236_((PoseStack)matrices, (Font)this.f_96547_, (String)textComponent, (int)0, (int)0, (int)color);
        matrices.m_85849_();
    }

    protected void m_7286_(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.GUI);
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(stack, relX - 23, relY, 0, 0, this.f_97726_ + 23, this.f_97727_);
    }

    public void m_7856_() {
        super.m_7856_();
        this.scrollingUpgrades = new ScrollingUpgrades(Minecraft.m_91087_(), this.f_97726_ - 14, 72, this.f_97736_ + 7, this.f_97735_ + 7, this);
        this.m_142416_((GuiEventListener)this.scrollingUpgrades);
    }

    public boolean m_6375_(double mouseXIn, double mouseYIn, int p_231044_5_) {
        ItemStack heldStack = ((ModificationTableContainer)this.f_97732_).m_142621_();
        ItemStack gadget = ((Slot)this.container.f_38839_.get(0)).m_7993_();
        if (!gadget.m_41619_() && gadget.m_41720_() instanceof MiningGadget && !heldStack.m_41619_() && heldStack.m_41720_() instanceof UpgradeCard && this.scrollingUpgrades.m_5953_(mouseXIn, mouseYIn)) {
            if (UpgradeTools.containsUpgrade(gadget, ((UpgradeCard)heldStack.m_41720_()).getUpgrade())) {
                return false;
            }
            PacketHandler.sendToServer(new PacketInsertUpgrade(this.tePos, heldStack));
            ((ModificationTableContainer)this.f_97732_).m_142503_(ItemStack.f_41583_);
        }
        return super.m_6375_(mouseXIn, mouseYIn, p_231044_5_);
    }

    private static class ScrollingUpgrades
    extends ScrollPanel
    implements NarratableEntry {
        ModificationTableScreen parent;
        Upgrade upgrade = null;

        ScrollingUpgrades(Minecraft client, int width, int height, int top, int left, ModificationTableScreen parent) {
            super(client, width, height, top, left);
            this.parent = parent;
        }

        public boolean m_6050_(double mouseX, double mouseY, double scroll) {
            if (this.getContentHeight() < this.height) {
                return false;
            }
            return super.m_6050_(mouseX, mouseY, scroll);
        }

        protected int getContentHeight() {
            return (int)Math.ceil((float)this.parent.container.getUpgradesCache().size() / 7.0f) * 20;
        }

        protected void drawPanel(PoseStack mStack, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
            Enum currentUpgrade = null;
            int x = entryRight - this.width + 3;
            int y = relativeY;
            int index = 0;
            for (Upgrade upgrade : this.parent.container.getUpgradesCache()) {
                Minecraft.m_91087_().m_91291_().m_115123_(new ItemStack((ItemLike)upgrade.getCard()), x, y);
                if (this.m_5953_(mouseX, mouseY) && mouseX > x && mouseX < x + 15 && mouseY > y && mouseY < y + 15) {
                    currentUpgrade = upgrade;
                }
                x += 22;
                if (++index % 7 != 0) continue;
                y += 20;
                x = entryRight - this.width + 3;
            }
            if (currentUpgrade == null || !currentUpgrade.equals((Object)this.upgrade)) {
                this.upgrade = currentUpgrade;
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (!this.m_5953_(mouseX, mouseY) || this.upgrade == null) {
                return false;
            }
            PacketHandler.sendToServer(new PacketExtractUpgrade(this.parent.tePos, this.upgrade.getName(), this.upgrade.getName().length()));
            return super.m_6375_(mouseX, mouseY, button);
        }

        public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
            super.m_6305_(stack, mouseX, mouseY, partialTicks);
            if (this.upgrade != null) {
                this.parent.m_96617_(stack, Lists.transform((List)this.upgrade.getStack().m_41651_((Player)this.parent.getMinecraft().f_91074_, (TooltipFlag)TooltipFlag.Default.NORMAL), Component::m_7532_), mouseX, mouseY);
            }
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput p_169152_) {
        }
    }
}

