/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.items;

import com.direwolf20.mininggadgets.client.OurKeys;
import com.direwolf20.mininggadgets.client.particles.playerparticle.PlayerParticleData;
import com.direwolf20.mininggadgets.client.screens.ModScreens;
import com.direwolf20.mininggadgets.common.Config;
import com.direwolf20.mininggadgets.common.MiningGadgets;
import com.direwolf20.mininggadgets.common.blocks.ModBlocks;
import com.direwolf20.mininggadgets.common.blocks.RenderBlock;
import com.direwolf20.mininggadgets.common.capabilities.CapabilityEnergyProvider;
import com.direwolf20.mininggadgets.common.items.UpgradeCard;
import com.direwolf20.mininggadgets.common.items.gadget.MiningCollect;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.items.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.items.upgrade.UpgradeTools;
import com.direwolf20.mininggadgets.common.sounds.LaserLoopSound;
import com.direwolf20.mininggadgets.common.sounds.OurSounds;
import com.direwolf20.mininggadgets.common.tiles.RenderBlockTileEntity;
import com.direwolf20.mininggadgets.common.util.MagicHelpers;
import com.direwolf20.mininggadgets.common.util.VectorHelper;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class MiningGadget
extends Item {
    private int energyCapacity;
    private Random rand = new Random();
    private LaserLoopSound laserLoopSound;

    public MiningGadget() {
        super(new Item.Properties().m_41487_(1).m_41491_(MiningGadgets.itemGroup).setNoRepair());
        this.energyCapacity = (Integer)Config.MININGGADGET_MAXPOWER.get();
    }

    public int getMaxDamage(ItemStack stack) {
        return this.energyCapacity;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        return energy.getEnergyStored() < energy.getMaxEnergyStored();
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new CapabilityEnergyProvider(stack, (Integer)Config.MININGGADGET_MAXPOWER.get());
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return stack.getCapability(CapabilityEnergy.ENERGY, null).map(e -> 1.0 - (double)e.getEnergyStored() / (double)e.getMaxEnergyStored()).orElse(0.0);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return stack.getCapability(CapabilityEnergy.ENERGY).map(e -> Mth.m_14169_((float)(Math.max(0.0f, (float)e.getEnergyStored() / (float)e.getMaxEnergyStored()) / 3.0f), (float)1.0f, (float)1.0f)).orElse(super.getRGBDurabilityForDisplay(stack));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        List<Upgrade> upgrades = UpgradeTools.getUpgrades(stack);
        Minecraft mc = Minecraft.m_91087_();
        if (world == null || mc.f_91074_ == null) {
            return;
        }
        boolean sneakPressed = Screen.m_96638_();
        if (!sneakPressed) {
            tooltip.add((Component)new TranslatableComponent("mininggadgets.tooltip.item.show_upgrades", new Object[]{"shift"}).m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)new TranslatableComponent("mininggadgets.tooltip.item.break_cost", new Object[]{MiningGadget.getEnergyCost(stack)}).m_130940_(ChatFormatting.RED));
            if (!upgrades.isEmpty()) {
                tooltip.add((Component)new TranslatableComponent("mininggadgets.tooltip.item.upgrades").m_130940_(ChatFormatting.AQUA));
                for (Upgrade upgrade : upgrades) {
                    tooltip.add((Component)new TextComponent(" - " + I18n.m_118938_((String)upgrade.getLocal(), (Object[])new Object[0])).m_130940_(ChatFormatting.GRAY));
                }
            }
        }
        stack.getCapability(CapabilityEnergy.ENERGY, null).ifPresent(energy -> {
            TranslatableComponent energyText = !sneakPressed ? new TranslatableComponent("mininggadgets.gadget.energy", new Object[]{MagicHelpers.tidyValue(energy.getEnergyStored()), MagicHelpers.tidyValue(energy.getMaxEnergyStored())}) : new TranslatableComponent("mininggadgets.gadget.energy", new Object[]{String.format("%,d", energy.getEnergyStored()), String.format("%,d", energy.getMaxEnergyStored())});
            tooltip.add((Component)energyText.m_130940_(ChatFormatting.GREEN));
        });
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        super.m_6787_(group, items);
        if (!this.m_41389_(group)) {
            return;
        }
        ItemStack charged = new ItemStack((ItemLike)this);
        charged.m_41784_().m_128347_("energy", (double)((Integer)Config.MININGGADGET_MAXPOWER.get()).intValue());
        items.add((Object)charged);
    }

    public static void changeRange(ItemStack tool) {
        if (MiningProperties.getRange(tool) == 1) {
            MiningProperties.setRange(tool, 3);
        } else {
            MiningProperties.setRange(tool, 1);
        }
    }

    public static boolean canMine(ItemStack tool) {
        IEnergyStorage energy = (IEnergyStorage)tool.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        int cost = MiningGadget.getEnergyCost(tool);
        if (MiningProperties.getRange(tool) == 3) {
            cost *= 9;
        }
        return energy.getEnergyStored() >= cost;
    }

    public static boolean canMineBlock(ItemStack tool, Level world, Player player, BlockPos pos, BlockState state) {
        if (!player.m_36326_() || !world.m_7966_(player, pos)) {
            return false;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, state, player))) {
            return false;
        }
        return MiningGadget.canMine(tool);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return true;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (player.m_6144_()) {
            if (!world.f_46443_) {
                MiningProperties.setCanMine(itemstack, true);
            }
            if (world.f_46443_ && OurKeys.shiftClickGuiBinding.getKey() == InputConstants.f_84822_) {
                ModScreens.openGadgetSettingsScreen(itemstack);
                return InteractionResultHolder.m_19098_((Object)itemstack);
            }
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (world.f_46443_) {
            float volume = MiningProperties.getVolume(itemstack);
            if (volume != 0.0f) {
                if (itemstack.m_41786_().getString().toLowerCase(Locale.ROOT).contains("mongo")) {
                    player.m_5496_(SoundEvents.f_12446_, volume * 0.5f, 1.0f);
                } else {
                    player.m_5496_(OurSounds.LASER_START.getSound(), volume * 0.5f, 1.0f);
                }
            }
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        if (!MiningGadget.canMine(itemstack)) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
        }
        player.m_6672_(hand);
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
    }

    public List<BlockPos> findSources(Level world, List<BlockPos> coords) {
        ArrayList<BlockPos> sources = new ArrayList<BlockPos>();
        for (BlockPos coord : coords) {
            for (Direction side : Direction.values()) {
                BlockPos sidePos = coord.m_142300_(side);
                FluidState state = world.m_6425_(sidePos);
                if (!state.m_76152_().m_6212_((Fluid)Fluids.f_76195_) && !state.m_76152_().m_6212_((Fluid)Fluids.f_76193_) || sources.contains(sidePos)) continue;
                sources.add(sidePos);
            }
        }
        return sources;
    }

    private void spawnFreezeParticle(Player player, BlockPos sourcePos, Level world, ItemStack stack) {
        float randomPartSize = 0.05f + 0.075f * this.rand.nextFloat();
        double randomTX = this.rand.nextDouble();
        double randomTY = this.rand.nextDouble();
        double randomTZ = this.rand.nextDouble();
        double alpha = -0.5 + 0.5 * this.rand.nextDouble();
        Vec3 playerPos = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
        Vec3 look = player.m_20154_();
        int range = MiningProperties.getBeamRange(stack);
        BlockHitResult lookAt = VectorHelper.getLookingAt(player, ClipContext.Fluid.NONE, range);
        Vec3 lookingAt = lookAt.m_82450_();
        Vec3 right = new Vec3(-look.f_82481_, 0.0, look.f_82479_).m_82541_();
        Vec3 forward = look;
        Vec3 backward = look.m_82542_(-1.0, 1.0, -1.0);
        Vec3 down = right.m_82537_(forward);
        right = right.m_82490_((double)0.65f);
        forward = forward.m_82490_((double)0.85f);
        down = down.m_82490_(-0.35);
        backward = backward.m_82490_(0.05);
        Vec3 laserPos = playerPos.m_82549_(right);
        laserPos = laserPos.m_82549_(forward);
        laserPos = laserPos.m_82549_(down);
        lookingAt = lookingAt.m_82549_(backward);
        PlayerParticleData data = PlayerParticleData.playerparticle("ice", (double)sourcePos.m_123341_() + randomTX, (double)sourcePos.m_123342_() + randomTY, (double)sourcePos.m_123343_() + randomTZ, randomPartSize, 1.0f, 1.0f, 1.0f, 120.0f, true);
        world.m_7106_((ParticleOptions)data, laserPos.f_82479_, laserPos.f_82480_, laserPos.f_82481_, 0.025, (double)0.025f, 0.025);
    }

    private void spawnFireParticle(BlockPos sourcePos, ServerLevel world) {
        double partType = this.rand.nextDouble();
        if (partType < 0.75) {
            return;
        }
        double randomTX = this.rand.nextDouble();
        double randomTY = this.rand.nextDouble();
        double randomTZ = this.rand.nextDouble();
        if (partType < 0.95) {
            world.m_8767_((ParticleOptions)ParticleTypes.f_123744_, (double)sourcePos.m_123341_() + randomTX, (double)sourcePos.m_123342_() + randomTY, (double)sourcePos.m_123343_() + randomTZ, 1, 0.0, 0.0, 0.0, 0.0);
        } else {
            world.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)sourcePos.m_123341_() + randomTX, (double)sourcePos.m_123342_() + randomTY, (double)sourcePos.m_123343_() + randomTZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playLoopSound(LivingEntity player, ItemStack stack) {
        float volume = MiningProperties.getVolume(stack);
        LocalPlayer myplayer = Minecraft.m_91087_().f_91074_;
        if (myplayer.equals((Object)player) && volume != 0.0f) {
            if (stack.m_41786_().getString().toLowerCase(Locale.ROOT).contains("mongo")) {
                if (player.f_19853_.m_46467_() % 5L == 0L) {
                    if (this.rand.nextDouble() > 0.005) {
                        player.m_5496_(SoundEvents.f_12446_, volume * 0.5f, 1.0f);
                    } else {
                        player.m_5496_(SoundEvents.f_11837_, volume * 1.0f, 1.0f);
                    }
                }
            } else if (this.laserLoopSound == null) {
                this.laserLoopSound = new LaserLoopSound((Player)player, volume);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.laserLoopSound);
            }
        }
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        Level world = player.f_19853_;
        if (world.f_46443_) {
            this.playLoopSound(player, stack);
        }
        if (!MiningProperties.getCanMine(stack)) {
            return;
        }
        if (!world.f_46443_ && stack.m_41786_().getString().toLowerCase(Locale.ROOT).contains("rgb")) {
            float beam2r = (float)MiningProperties.getColor(stack, "colorRedInner") / 255.0f;
            float beam2g = (float)MiningProperties.getColor(stack, "colorGreenInner") / 255.0f;
            float beam2b = (float)MiningProperties.getColor(stack, "colorBlueInner") / 255.0f;
            float r = (float)MiningProperties.getColor(stack, "colorRed") / 255.0f;
            float g = (float)MiningProperties.getColor(stack, "colorGreen") / 255.0f;
            float b = (float)MiningProperties.getColor(stack, "colorBlue") / 255.0f;
            if (beam2r < 1.0f && beam2g == 0.0f) {
                MiningProperties.setColor(stack, (short)(beam2r * 255.0f + Math.min(255.0f - beam2r * 255.0f, 5.0f)), "colorRedInner");
            } else if (beam2b > 0.0f && beam2r == 1.0f) {
                MiningProperties.setColor(stack, (short)(beam2b * 255.0f - Math.min(Math.abs(0.0f - beam2b * 255.0f), 5.0f)), "colorBlueInner");
            } else if (beam2g < 1.0f && beam2r == 1.0f) {
                MiningProperties.setColor(stack, (short)(beam2g * 255.0f + Math.min(255.0f - beam2g * 255.0f, 5.0f)), "colorGreenInner");
            } else if (beam2r > 0.0f && beam2g == 1.0f) {
                MiningProperties.setColor(stack, (short)(beam2r * 255.0f - Math.min(Math.abs(0.0f - beam2r * 255.0f), 5.0f)), "colorRedInner");
            } else if (beam2b < 1.0f && beam2g == 1.0f) {
                MiningProperties.setColor(stack, (short)(beam2b * 255.0f + Math.min(255.0f - beam2b * 255.0f, 5.0f)), "colorBlueInner");
            } else if (beam2g > 0.0f && beam2b == 1.0f) {
                MiningProperties.setColor(stack, (short)(beam2g * 255.0f - Math.min(Math.abs(0.0f - beam2g * 255.0f), 5.0f)), "colorGreenInner");
            }
            if (r < 1.0f && g == 0.0f) {
                MiningProperties.setColor(stack, (short)(r * 255.0f + Math.min(255.0f - r * 255.0f, 5.0f)), "colorRed");
            } else if (b > 0.0f && r == 1.0f) {
                MiningProperties.setColor(stack, (short)(b * 255.0f - Math.min(Math.abs(0.0f - b * 255.0f), 5.0f)), "colorBlue");
            } else if (g < 1.0f && r == 1.0f) {
                MiningProperties.setColor(stack, (short)(g * 255.0f + Math.min(255.0f - g * 255.0f, 5.0f)), "colorGreen");
            } else if (r > 0.0f && g == 1.0f) {
                MiningProperties.setColor(stack, (short)(r * 255.0f - Math.min(Math.abs(0.0f - r * 255.0f), 5.0f)), "colorRed");
            } else if (b < 1.0f && g == 1.0f) {
                MiningProperties.setColor(stack, (short)(b * 255.0f + Math.min(255.0f - b * 255.0f, 5.0f)), "colorBlue");
            } else if (g > 0.0f && b == 1.0f) {
                MiningProperties.setColor(stack, (short)(g * 255.0f - Math.min(Math.abs(0.0f - g * 255.0f), 5.0f)), "colorGreen");
            }
        }
        int range = MiningProperties.getBeamRange(stack);
        BlockHitResult lookingAt = VectorHelper.getLookingAt((Player)player, ClipContext.Fluid.NONE, range);
        if (world.m_8055_(VectorHelper.getLookingAt((Player)player, stack, range).m_82425_()) == Blocks.f_50016_.m_49966_()) {
            return;
        }
        List<BlockPos> coords = MiningCollect.collect((Player)player, lookingAt, world, MiningProperties.getRange(stack));
        if (UpgradeTools.containsActiveUpgrade(stack, Upgrade.FREEZING)) {
            for (BlockPos sourcePos : this.findSources(player.f_19853_, coords)) {
                int delay = MiningProperties.getFreezeDelay(stack);
                if (delay != 0 && count % delay != 0) continue;
                this.spawnFreezeParticle((Player)player, sourcePos, player.f_19853_, stack);
            }
        }
        if (!world.f_46443_) {
            int energy;
            int efficiency = 0;
            if (UpgradeTools.containsActiveUpgrade(stack, Upgrade.EFFICIENCY_1)) {
                efficiency = UpgradeTools.getUpgradeFromGadget(stack, Upgrade.EFFICIENCY_1).get().getTier();
            }
            float hardness = MiningGadget.getHardness(coords, (Player)player, efficiency);
            hardness = hardness * (float)MiningProperties.getRange(stack) * 1.0f;
            if ((hardness = (float)Math.floor(hardness)) == 0.0f) {
                hardness = 1.0f;
            }
            for (BlockPos coord : coords) {
                BlockState state = world.m_8055_(coord);
                if (!(state.m_60734_() instanceof RenderBlock)) {
                    if (!MiningGadget.canMineBlock(stack, world, (Player)player, coord, state)) {
                        return;
                    }
                    List<Upgrade> gadgetUpgrades = UpgradeTools.getUpgrades(stack);
                    boolean placed = world.m_46597_(coord, ((Block)ModBlocks.RENDER_BLOCK.get()).m_49966_());
                    RenderBlockTileEntity te = (RenderBlockTileEntity)world.m_7702_(coord);
                    if (!placed || te == null) {
                        return;
                    }
                    te.setRenderBlock(state);
                    te.setBreakType(MiningProperties.getBreakType(stack));
                    te.setGadgetUpgrades(gadgetUpgrades);
                    te.setGadgetFilters(MiningProperties.getFiltersAsList(stack));
                    te.setGadgetIsWhitelist(MiningProperties.getWhiteList(stack));
                    te.setPriorDurability((int)hardness + 1);
                    te.setOriginalDurability((int)hardness + 1);
                    te.setDurability((int)hardness, stack);
                    te.setPlayer((Player)player);
                    te.setBlockAllowed();
                } else {
                    RenderBlockTileEntity te = (RenderBlockTileEntity)world.m_7702_(coord);
                    if (te != null) {
                        int durability = te.getDurability();
                        if (--durability <= 0) {
                            stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> e.receiveEnergy(MiningGadget.getEnergyCost(stack) * -1, false));
                            if (MiningProperties.getPrecisionMode(stack)) {
                                MiningProperties.setCanMine(stack, false);
                                player.m_5810_();
                            }
                        }
                        te.setDurability(durability, stack);
                    }
                }
                if (!stack.m_41786_().getString().toLowerCase(Locale.ROOT).contains("wildfirev")) continue;
                this.spawnFireParticle(coord, (ServerLevel)player.f_19853_);
            }
            if (!UpgradeTools.containsActiveUpgrade(stack, Upgrade.LIGHT_PLACER)) {
                return;
            }
            Direction side = lookingAt.m_82434_();
            boolean vertical = side.m_122434_().m_122478_();
            Direction up = vertical ? player.m_6350_() : Direction.UP;
            Direction right = vertical ? up.m_122427_() : side.m_122428_();
            BlockPos pos = MiningProperties.getRange(stack) == 1 ? lookingAt.m_82425_().m_5484_(side, 4) : lookingAt.m_82425_().m_142300_(side).m_142300_(right);
            if (world.m_46803_(pos) <= 7 && world.m_8055_(pos).m_60767_() == Material.f_76296_ && (energy = stack.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0).intValue()) > (Integer)Config.UPGRADECOST_LIGHT.get()) {
                world.m_46597_(pos, ((Block)ModBlocks.MINERS_LIGHT.get()).m_49966_());
                stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> e.receiveEnergy((Integer)Config.UPGRADECOST_LIGHT.get() * -1, false));
            }
        }
    }

    public static int getEnergyCost(ItemStack stack) {
        int cost = (Integer)Config.MININGGADGET_BASECOST.get();
        List<Upgrade> upgrades = UpgradeTools.getActiveUpgrades(stack);
        if (upgrades.isEmpty()) {
            return cost;
        }
        return cost + upgrades.stream().mapToInt(Upgrade::getCostPerBlock).sum();
    }

    private static float getHardness(List<BlockPos> coords, Player player, int efficiency) {
        MobEffectInstance miningFatigue;
        MobEffectInstance hasteEffect;
        float hardness = 0.0f;
        float toolSpeed = 8.0f;
        if (efficiency > 0) {
            toolSpeed += (float)(efficiency * efficiency + 1);
        }
        if ((hasteEffect = player.m_21124_(MobEffects.f_19598_)) != null) {
            int hasteLevel = hasteEffect.m_19564_() + 1;
            toolSpeed += toolSpeed * ((float)hasteLevel * 20.0f / 100.0f);
        }
        if ((miningFatigue = player.m_21124_(MobEffects.f_19599_)) != null) {
            toolSpeed /= 3.0f;
        }
        Level world = player.f_19853_;
        for (BlockPos coord : coords) {
            RenderBlockTileEntity blockEntity;
            BlockState state = world.m_8055_(coord);
            float temphardness = state.m_60800_((BlockGetter)world, coord);
            if (state.m_60734_() instanceof RenderBlock && (blockEntity = (RenderBlockTileEntity)world.m_7702_(coord)) != null) {
                temphardness = blockEntity.getRenderBlock().m_60800_((BlockGetter)world, coord);
            }
            hardness += temphardness * 30.0f / toolSpeed;
        }
        return hardness / (float)coords.size();
    }

    public static void applyUpgrade(ItemStack tool, UpgradeCard upgradeCard) {
        if (UpgradeTools.containsUpgrade(tool, upgradeCard.getUpgrade())) {
            return;
        }
        UpgradeTools.setUpgrade(tool, upgradeCard);
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (worldIn.f_46443_ && this.laserLoopSound != null) {
            float volume = MiningProperties.getVolume(stack);
            if (volume != 0.0f && !this.laserLoopSound.m_7801_()) {
                entityLiving.m_5496_(OurSounds.LASER_END.getSound(), volume * 0.5f, 1.0f);
            }
            this.laserLoopSound = null;
        }
        if (entityLiving instanceof Player) {
            entityLiving.m_5810_();
        }
        if (!worldIn.f_46443_) {
            MiningProperties.setCanMine(stack, true);
        }
    }

    public static ItemStack getGadget(Player player) {
        ItemStack heldItem = player.m_21205_();
        if (!(heldItem.m_41720_() instanceof MiningGadget) && !((heldItem = player.m_21206_()).m_41720_() instanceof MiningGadget)) {
            return ItemStack.f_41583_;
        }
        return heldItem;
    }

    public static boolean isHolding(Player entity) {
        return MiningGadget.getGadget(entity).m_41720_() instanceof MiningGadget;
    }
}

