/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.network.packets;

import com.direwolf20.mininggadgets.common.containers.ModificationTableCommands;
import com.direwolf20.mininggadgets.common.containers.ModificationTableContainer;
import com.direwolf20.mininggadgets.common.tiles.ModificationTableTileEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class PacketExtractUpgrade {
    private final BlockPos pos;
    private final String upgrade;
    private final int nameLength;

    public PacketExtractUpgrade(BlockPos blockPos, String upgrade, int nameLength) {
        this.pos = blockPos;
        this.upgrade = upgrade;
        this.nameLength = nameLength;
    }

    public static void encode(PacketExtractUpgrade msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.nameLength);
        buffer.m_130064_(msg.pos);
        buffer.m_130070_(msg.upgrade);
    }

    public static PacketExtractUpgrade decode(FriendlyByteBuf buffer) {
        int strLength = buffer.readInt();
        return new PacketExtractUpgrade(buffer.m_130135_(), buffer.m_130136_(strLength), strLength);
    }

    public static class Handler {
        public static void handle(PacketExtractUpgrade msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    return;
                }
                Level world = player.f_19853_;
                BlockPos pos = msg.pos;
                BlockEntity te = world.m_7702_(pos);
                if (!(te instanceof ModificationTableTileEntity)) {
                    return;
                }
                ModificationTableContainer container = ((ModificationTableTileEntity)te).getContainer((Player)player);
                ModificationTableCommands.extractButton(container, player, msg.upgrade);
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

