/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.network.packets;

import com.direwolf20.mininggadgets.common.containers.GhostSlot;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class PacketGhostSlot {
    private int slotNumber;
    private ItemStack stack;

    public PacketGhostSlot(int slotNumber, ItemStack stack) {
        this.slotNumber = slotNumber;
        this.stack = stack;
    }

    public static void encode(PacketGhostSlot msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.slotNumber);
        buffer.m_130055_(msg.stack);
    }

    public static PacketGhostSlot decode(FriendlyByteBuf buffer) {
        return new PacketGhostSlot(buffer.readInt(), buffer.m_130267_());
    }

    public static class Handler {
        public static void handle(PacketGhostSlot msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
                if (sender == null) {
                    return;
                }
                AbstractContainerMenu container = sender.f_36096_;
                if (container == null) {
                    return;
                }
                Slot slot = (Slot)container.f_38839_.get(msg.slotNumber);
                if (slot instanceof GhostSlot) {
                    slot.m_5852_(msg.stack);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

