/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.network.packets;

import com.direwolf20.mininggadgets.common.containers.ModificationTableCommands;
import com.direwolf20.mininggadgets.common.containers.ModificationTableContainer;
import com.direwolf20.mininggadgets.common.tiles.ModificationTableTileEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public final class PacketInsertUpgrade {
    private final BlockPos pos;
    private final ItemStack upgrade;

    public static PacketInsertUpgrade decode(FriendlyByteBuf buffer) {
        return new PacketInsertUpgrade(buffer.m_130135_(), buffer.m_130267_());
    }

    public PacketInsertUpgrade(BlockPos blockPos, ItemStack stack) {
        this.pos = blockPos;
        this.upgrade = stack;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_130055_(this.upgrade);
    }

    public void handler(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            Level world = player.f_19853_;
            BlockPos pos = this.pos;
            BlockEntity te = world.m_7702_(pos);
            if (!(te instanceof ModificationTableTileEntity)) {
                return;
            }
            ModificationTableContainer container = ((ModificationTableTileEntity)te).getContainer((Player)player);
            ItemStack stack = player.f_36096_.m_142621_();
            if (!stack.m_41656_(this.upgrade)) {
                return;
            }
            if (ModificationTableCommands.insertButton(container, this.upgrade)) {
                player.f_36096_.m_142503_(ItemStack.f_41583_);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

