/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.renderer;

import com.direwolf20.mininggadgets.common.blocks.RenderBlock;
import com.direwolf20.mininggadgets.common.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.tiles.RenderBlockTileEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IEnviromentBlockReader;
import org.lwjgl.opengl.GL14;

public class RenderBlockTER
extends TileEntityRenderer<RenderBlockTileEntity> {
    private void renderModelBrightnessColorQuads(float brightness, float red, float green, float blue, List<BakedQuad> listQuads) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        int j = listQuads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = listQuads.get(i);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            bufferbuilder.func_178981_a(bakedquad.func_178209_a());
            if (bakedquad.func_178212_b()) {
                bufferbuilder.func_178990_f(red * brightness, green * brightness, blue * brightness);
            } else {
                bufferbuilder.func_178990_f(brightness, brightness, brightness);
            }
            Vec3i vec3i = bakedquad.func_178210_d().func_176730_m();
            bufferbuilder.func_178975_e((float)vec3i.func_177958_n(), (float)vec3i.func_177956_o(), (float)vec3i.func_177952_p());
            tessellator.func_78381_a();
        }
    }

    public void render(RenderBlockTileEntity tile, double x, double y, double z, float partialTicks, int destroyStage) {
        float nowScale;
        int durability = tile.getDurability();
        int originalDurability = tile.getOriginalDurability();
        int prevDurability = tile.getPriorDurability();
        float prevScale = (float)prevDurability / (float)originalDurability;
        float scale = MathHelper.func_219799_g((float)partialTicks, (float)prevScale, (float)(nowScale = (float)durability / (float)originalDurability));
        if (scale >= 1.0f) {
            scale = 1.0f;
        }
        if (scale <= 0.0f) {
            scale = 0.0f;
        }
        float trans = (1.0f - scale) / 2.0f;
        BlockState renderState = tile.getRenderBlock();
        if (renderState == null) {
            return;
        }
        BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        GlStateManager.pushMatrix();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)32771, (int)32772);
        MiningProperties.BreakTypes breakType = tile.getBreakType();
        GlStateManager.translated((double)x, (double)y, (double)z);
        IBakedModel ibakedmodel = blockrendererdispatcher.func_184389_a(renderState);
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        int color = blockColors.func_216860_a(renderState, (IEnviromentBlockReader)tile.func_145831_w(), tile.func_174877_v(), 0);
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        if (breakType == MiningProperties.BreakTypes.SHRINK) {
            GlStateManager.translatef((float)((1.0f - scale) / 2.0f), (float)((1.0f - scale) / 2.0f), (float)((1.0f - scale) / 2.0f));
            GlStateManager.scalef((float)scale, (float)scale, (float)scale);
            GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            try {
                for (Direction direction : Direction.values()) {
                    this.renderModelBrightnessColorQuads(1.0f, f, f1, f2, ibakedmodel.func_200117_a(renderState, direction, new Random(MathHelper.func_180186_a((Vec3i)tile.func_174877_v()))));
                }
            }
            catch (Throwable t) {
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferBuilder = tessellator.func_178180_c();
                try {
                    bufferBuilder.func_178977_d();
                }
                catch (IllegalStateException direction) {}
            }
        } else if (breakType == MiningProperties.BreakTypes.FADE) {
            scale = MathHelper.func_219799_g((float)scale, (float)0.1f, (float)1.0f);
            GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)scale);
            GlStateManager.depthMask((boolean)false);
            try {
                for (Direction direction : Direction.values()) {
                    if (this.func_178459_a().func_180495_p(tile.func_174877_v().func_177972_a(direction)).func_177230_c() instanceof RenderBlock) continue;
                    this.renderModelBrightnessColorQuads(1.0f, f, f1, f2, ibakedmodel.func_200117_a(renderState, direction, new Random(MathHelper.func_180186_a((Vec3i)tile.func_174877_v()))));
                }
            }
            catch (Throwable t) {
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferBuilder = tessellator.func_178180_c();
                try {
                    bufferBuilder.func_178977_d();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            GlStateManager.depthMask((boolean)true);
        }
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
    }
}

