/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.renderer;

import com.direwolf20.mininggadgets.common.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.gadget.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.gadget.upgrade.UpgradeTools;
import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.common.util.VectorHelper;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;

public class RenderMiningLaser {
    private static final ResourceLocation laserBeam = new ResourceLocation("mininggadgets:textures/misc/laser.png");
    private static final ResourceLocation laserBeam2 = new ResourceLocation("mininggadgets:textures/misc/laser2.png");
    private static final ResourceLocation laserBeamGlow = new ResourceLocation("mininggadgets:textures/misc/laser_glow.png");

    public static void renderLaser(PlayerEntity player, float ticks) {
        ItemStack stack = MiningGadget.getGadget(player);
        if (!MiningProperties.getCanMine(stack)) {
            return;
        }
        int range = MiningProperties.getBeamRange(stack);
        BlockRayTraceResult lookingAt = VectorHelper.getLookingAt(player, RayTraceContext.FluidMode.NONE, range);
        Vec3d playerPos = player.func_174824_e(ticks);
        Vec3d lookBlockPos = lookingAt.func_216347_e();
        float speedModifier = RenderMiningLaser.getSpeedModifier(stack);
        RenderMiningLaser.drawLasers(playerPos, lookBlockPos, 0.0, 0.0, 0.0, (float)MiningProperties.getColor(stack, "colorRed") / 255.0f, (float)MiningProperties.getColor(stack, "colorGreen") / 255.0f, (float)MiningProperties.getColor(stack, "colorBlue") / 255.0f, 0.02f, player, ticks, speedModifier);
    }

    private static float getSpeedModifier(ItemStack stack) {
        if (UpgradeTools.containsUpgrade(stack, Upgrade.EFFICIENCY_1)) {
            double efficiency = (float)UpgradeTools.getUpgradeFromGadget(stack, Upgrade.EFFICIENCY_1).get().getTier() / 5.0f;
            double speedModifier = MathHelper.func_219803_d((double)efficiency, (double)0.02, (double)0.05);
            return (float)(-speedModifier);
        }
        return -0.02f;
    }

    private static void drawLasers(Vec3d from, Vec3d to, double xOffset, double yOffset, double zOffset, float r, float g, float b, float thickness, PlayerEntity player, float ticks, float speedModifier) {
        Hand activeHand;
        if (player.func_184614_ca().func_77973_b() instanceof MiningGadget) {
            activeHand = Hand.MAIN_HAND;
        } else if (player.func_184592_cb().func_77973_b() instanceof MiningGadget) {
            activeHand = Hand.OFF_HAND;
        } else {
            return;
        }
        ItemStack stack = player.func_184586_b(activeHand);
        Vec3d playerPos = new Vec3d(TileEntityRendererDispatcher.field_147554_b, TileEntityRendererDispatcher.field_147555_c, TileEntityRendererDispatcher.field_147552_d);
        double distance = from.func_178788_d(to).func_72433_c();
        long gameTime = player.field_70170_p.func_82737_E();
        double v = (float)gameTime * speedModifier;
        float additiveThickness = thickness * 3.5f * RenderMiningLaser.calculateLaserFlickerModifier(gameTime);
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.pushMatrix();
        GlStateManager.enableColorMaterial();
        GlStateManager.disableDepthTest();
        GlStateManager.enableBlend();
        GlStateManager.disableCull();
        GlStateManager.enableTexture();
        GlStateManager.translated((double)(-playerPos.func_82615_a()), (double)(-playerPos.func_82617_b()), (double)(-playerPos.func_82616_c()));
        GlStateManager.translated((double)from.field_72450_a, (double)from.field_72448_b, (double)from.field_72449_c);
        GlStateManager.rotatef((float)MathHelper.func_219799_g((float)ticks, (float)(-player.field_70177_z), (float)(-player.field_70126_B)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)MathHelper.func_219799_g((float)ticks, (float)player.field_70125_A, (float)player.field_70127_C), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.color4f((float)r, (float)g, (float)b, (float)0.7f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(laserBeamGlow);
        RenderMiningLaser.drawBeam(xOffset, yOffset, zOffset, additiveThickness, activeHand, distance, wr, 0.5, 1.0, ticks);
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.color3f((float)r, (float)g, (float)b);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(laserBeam2);
        RenderMiningLaser.drawBeam(xOffset, yOffset, zOffset, thickness, activeHand, distance, wr, v, v + distance * 1.5, ticks);
        GlStateManager.color3f((float)((float)MiningProperties.getColor(stack, "colorRedInner") / 255.0f), (float)((float)MiningProperties.getColor(stack, "colorGreenInner") / 255.0f), (float)((float)MiningProperties.getColor(stack, "colorBlueInner") / 255.0f));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(laserBeam);
        RenderMiningLaser.drawBeam(xOffset, yOffset, zOffset, thickness / 2.0f, activeHand, distance, wr, v, v + distance * 1.5, ticks);
        GlStateManager.enableDepthTest();
        GlStateManager.enableCull();
        GlStateManager.popMatrix();
    }

    private static float calculateLaserFlickerModifier(long gameTime) {
        return 0.9f + 0.1f * MathHelper.func_76126_a((float)((float)gameTime * 0.99f)) * MathHelper.func_76126_a((float)((float)gameTime * 0.3f)) * MathHelper.func_76126_a((float)((float)gameTime * 0.1f));
    }

    private static void drawBeam(double xOffset, double yOffset, double zOffset, float thickness, Hand hand, double distance, BufferBuilder wr, double v1, double v2, float ticks) {
        float startXOffset = -0.25f;
        float startYOffset = -0.115f;
        float startZOffset = 0.65f;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        float f = MathHelper.func_219799_g((float)ticks, (float)player.field_70127_C, (float)player.field_70125_A) - MathHelper.func_219799_g((float)ticks, (float)player.field_71164_i, (float)player.field_71155_g);
        float f1 = MathHelper.func_219799_g((float)ticks, (float)player.field_70126_B, (float)player.field_70177_z) - MathHelper.func_219799_g((float)ticks, (float)player.field_71163_h, (float)player.field_71154_f);
        startXOffset += f1 / 1000.0f;
        startYOffset += f / 1000.0f;
        if (Minecraft.func_71410_x().field_71474_y.field_186715_A != HandSide.RIGHT) {
            hand = hand == Hand.MAIN_HAND ? Hand.OFF_HAND : Hand.MAIN_HAND;
        }
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        if (hand == Hand.MAIN_HAND) {
            wr.func_181662_b((double)startXOffset, (double)(-thickness + startYOffset), (double)startZOffset).func_187315_a(1.0, v1).func_181675_d();
            wr.func_181662_b(xOffset, (double)(-thickness) + yOffset, distance + zOffset).func_187315_a(1.0, v2).func_181675_d();
            wr.func_181662_b(xOffset, (double)thickness + yOffset, distance + zOffset).func_187315_a(0.0, v2).func_181675_d();
            wr.func_181662_b((double)startXOffset, (double)(thickness + startYOffset), (double)startZOffset).func_187315_a(0.0, v1).func_181675_d();
        } else {
            startYOffset = -0.12f;
            wr.func_181662_b((double)(-startXOffset), (double)(thickness + startYOffset), (double)startZOffset).func_187315_a(0.0, v1).func_181675_d();
            wr.func_181662_b(xOffset, (double)thickness + yOffset, distance + zOffset).func_187315_a(0.0, v2).func_181675_d();
            wr.func_181662_b(xOffset, (double)(-thickness) + yOffset, distance + zOffset).func_187315_a(1.0, v2).func_181675_d();
            wr.func_181662_b((double)(-startXOffset), (double)(-thickness + startYOffset), (double)startZOffset).func_187315_a(1.0, v1).func_181675_d();
        }
        Tessellator.func_178181_a().func_78381_a();
    }
}

