/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.screens;

import com.direwolf20.mininggadgets.client.screens.ModScreens;
import com.direwolf20.mininggadgets.client.screens.widget.ToggleButton;
import com.direwolf20.mininggadgets.common.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.gadget.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.gadget.upgrade.UpgradeTools;
import com.direwolf20.mininggadgets.common.network.PacketHandler;
import com.direwolf20.mininggadgets.common.network.packets.PacketChangeMiningSize;
import com.direwolf20.mininggadgets.common.network.packets.PacketChangeRange;
import com.direwolf20.mininggadgets.common.network.packets.PacketOpenFilterContainer;
import com.direwolf20.mininggadgets.common.network.packets.PacketToggleFilters;
import com.direwolf20.mininggadgets.common.network.packets.PacketTogglePrecision;
import com.direwolf20.mininggadgets.common.network.packets.PacketUpdateUpgrade;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.config.GuiSlider;

public class MiningSettingScreen
extends Screen
implements GuiSlider.ISlider {
    private ItemStack gadget;
    private Button sizeButton;
    private int beamRange = 0;
    private int currentSize = 1;
    private boolean isWhitelist = true;
    private boolean isPrecision = true;
    private GuiSlider rangeSlider;
    private List<Upgrade> toggleableList = new ArrayList<Upgrade>();

    public MiningSettingScreen(ItemStack gadget) {
        super((ITextComponent)new StringTextComponent("title"));
        this.gadget = gadget;
        this.beamRange = MiningProperties.getBeamRange(gadget);
    }

    protected void init() {
        int baseX = this.width / 2;
        int baseY = this.height / 2;
        this.toggleableList.clear();
        this.toggleableList = UpgradeTools.getUpgrades(this.gadget).stream().filter(Upgrade::isToggleable).collect(Collectors.toList());
        boolean containsVoid = UpgradeTools.containsUpgradeFromList(this.toggleableList, Upgrade.VOID_JUNK);
        this.isWhitelist = MiningProperties.getWhiteList(this.gadget);
        this.isPrecision = MiningProperties.getPrecisionMode(this.gadget);
        int index = 0;
        int x = baseX + 10;
        int y = baseY - (containsVoid ? 20 : 50);
        for (Upgrade upgrade : this.toggleableList) {
            this.addButton(new ToggleButton(x + index * 30, y, UpgradeTools.getName(upgrade), new ResourceLocation("mininggadgets", "textures/item/upgrade_" + upgrade.getName() + ".png"), send -> this.toggleUpgrade(upgrade, (boolean)send)));
            if (++index % 4 != 0) continue;
            index = 0;
            y += 35;
        }
        this.currentSize = MiningProperties.getRange(this.gadget);
        this.sizeButton = new Button(baseX - 135, baseY - 50, 115, 20, new TranslationTextComponent("mininggadgets.tooltip.screen.size", new Object[]{this.currentSize}).func_150261_e(), button -> {
            this.currentSize = this.currentSize == 1 ? 3 : 1;
            button.setMessage(MiningSettingScreen.getTrans("tooltip.screen.size", this.currentSize));
            PacketHandler.sendToServer(new PacketChangeMiningSize());
        });
        this.rangeSlider = new GuiSlider(baseX - 135, baseY - 25, 115, 20, MiningSettingScreen.getTrans("tooltip.screen.range", new Object[0]) + ": ", "", 1.0, (double)MiningProperties.getBeamMaxRange(this.gadget), (double)this.beamRange, false, true, s -> {}, (GuiSlider.ISlider)this);
        this.addButton((Widget)this.sizeButton);
        this.addButton((Widget)this.rangeSlider);
        this.addButton((Widget)new Button(baseX - 135, baseY, 115, 20, MiningSettingScreen.getTrans("tooltip.screen.visuals_menu", new Object[0]), button -> ModScreens.openVisualSettingsScreen(this.gadget)));
        this.addButton((Widget)new Button(baseX - 135, baseY + 25, 115, 20, MiningSettingScreen.getTrans("tooltip.screen.precision_mode", this.isPrecision), button -> {
            this.isPrecision = !this.isPrecision;
            button.setMessage(MiningSettingScreen.getTrans("tooltip.screen.precision_mode", this.isPrecision));
            PacketHandler.sendToServer(new PacketTogglePrecision());
        }));
        if (containsVoid) {
            this.addButton((Widget)new Button(baseX + 10, baseY - 50, 95, 20, MiningSettingScreen.getTrans("tooltip.screen.edit_filters", new Object[0]), button -> PacketHandler.sendToServer(new PacketOpenFilterContainer())));
            this.addButton((Widget)new WhitelistButton(baseX + 10 + 95, baseY - 50, 20, 20, this.isWhitelist, button -> {
                this.isWhitelist = !this.isWhitelist;
                ((WhitelistButton)button).setWhitelist(this.isWhitelist);
                PacketHandler.sendToServer(new PacketToggleFilters());
            }));
        }
        if (!UpgradeTools.containsActiveUpgrade(this.gadget, Upgrade.THREE_BY_THREE)) {
            this.sizeButton.active = false;
        }
    }

    private boolean toggleUpgrade(Upgrade upgrade, boolean update) {
        if (update) {
            PacketHandler.sendToServer(new PacketUpdateUpgrade(upgrade.getName()));
        }
        return upgrade.isEnabled();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.drawString(this.getMinecraft().field_71466_p, MiningSettingScreen.getTrans("tooltip.screen.mining_gadget", new Object[0]), this.width / 2 - 135, this.height / 2 - 70, Color.WHITE.getRGB());
        this.drawString(this.getMinecraft().field_71466_p, MiningSettingScreen.getTrans("tooltip.screen.toggle_upgrades", new Object[0]), this.width / 2 + 10, this.height / 2 - 70, Color.WHITE.getRGB());
        if (this.toggleableList.size() == 0) {
            this.drawString(this.getMinecraft().field_71466_p, MiningSettingScreen.getTrans("tooltip.screen.no_upgrades", new Object[0]), this.width / 2 + 10, this.height / 2 - 50, Color.GRAY.getRGB());
        }
        this.children.forEach(e -> {
            if (!(e instanceof ToggleButton) && !(e instanceof WhitelistButton)) {
                return;
            }
            if (e instanceof WhitelistButton) {
                if (e.isMouseOver((double)mouseX, (double)mouseY)) {
                    this.renderTooltip(this.isWhitelist ? MiningSettingScreen.getTrans("tooltip.screen.whitelist", new Object[0]) : MiningSettingScreen.getTrans("tooltip.screen.blacklist", new Object[0]), mouseX, mouseY);
                }
            } else {
                ToggleButton btn = (ToggleButton)((Object)e);
                if (btn.isMouseOver(mouseX, mouseY)) {
                    this.renderTooltip(btn.getTooltip(), mouseX, mouseY);
                }
            }
        });
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        super.onClose();
        PacketHandler.sendToServer(new PacketChangeRange(this.beamRange));
    }

    public void onChangeSliderValue(GuiSlider slider) {
        if (slider.equals(this.rangeSlider)) {
            this.beamRange = slider.getValueInt();
        }
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.rangeSlider.dragging = false;
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        if (this.rangeSlider.isMouseOver(mouseX, mouseY)) {
            this.rangeSlider.sliderValue = this.rangeSlider.sliderValue + (double)(0.1f * (float)(delta > 0.0 ? 1 : -1));
            this.rangeSlider.updateSlider();
        }
        return false;
    }

    private static String getTrans(String key, Object ... args) {
        return new TranslationTextComponent("mininggadgets." + key, args).func_150261_e();
    }

    public static final class WhitelistButton
    extends Button {
        private boolean isWhitelist;

        public WhitelistButton(int widthIn, int heightIn, int width, int height, boolean isWhitelist, Button.IPressable onPress) {
            super(widthIn, heightIn, width, height, "", onPress);
            this.isWhitelist = isWhitelist;
        }

        public void renderButton(int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
            GlStateManager.disableTexture();
            GlStateManager.color4f((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
            this.blit(this.x, this.y, 0, 0, this.width, this.height);
            if (this.isWhitelist) {
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                GlStateManager.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            this.blit(this.x + 2, this.y + 2, 0, 0, this.width - 4, this.height - 4);
            GlStateManager.enableTexture();
        }

        public void setWhitelist(boolean whitelist) {
            this.isWhitelist = whitelist;
        }
    }
}

