/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.screens;

import com.direwolf20.mininggadgets.common.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.network.PacketHandler;
import com.direwolf20.mininggadgets.common.network.packets.PacketChangeBreakType;
import com.direwolf20.mininggadgets.common.network.packets.PacketChangeColor;
import java.awt.Color;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.config.GuiSlider;

public class MiningVisualsScreen
extends Screen
implements GuiSlider.ISlider {
    private ItemStack gadget;
    private Button blockBreakButton;
    private int red;
    private int green;
    private int blue;
    private int red_inner;
    private int green_inner;
    private int blue_inner;
    private GuiSlider sliderRedInner;
    private GuiSlider sliderGreenInner;
    private GuiSlider sliderBlueInner;
    private GuiSlider sliderRedOuter;
    private GuiSlider sliderGreenOuter;
    private GuiSlider sliderBlueOuter;

    public MiningVisualsScreen(ItemStack gadget) {
        super((ITextComponent)new StringTextComponent("title"));
        this.gadget = gadget;
        this.red = MiningProperties.getColor(gadget, "colorRed");
        this.green = MiningProperties.getColor(gadget, "colorGreen");
        this.blue = MiningProperties.getColor(gadget, "colorBlue");
        this.red_inner = MiningProperties.getColor(gadget, "colorRedInner");
        this.green_inner = MiningProperties.getColor(gadget, "colorGreenInner");
        this.blue_inner = MiningProperties.getColor(gadget, "colorBlueInner");
    }

    protected void init() {
        int baseX = this.width / 2;
        int baseY = this.height / 2;
        String buttonText = MiningProperties.getBreakType(this.gadget) == MiningProperties.BreakTypes.SHRINK ? new TranslationTextComponent("mininggadgets.tooltip.screen.shrink", new Object[0]).func_150261_e() : new TranslationTextComponent("mininggadgets.tooltip.screen.fade", new Object[0]).func_150261_e();
        this.blockBreakButton = new Button(baseX - 75, baseY - 50, 150, 20, buttonText, button -> {
            if (this.blockBreakButton.getMessage().contains("Shrink")) {
                button.setMessage(new TranslationTextComponent("mininggadgets.tooltip.screen.fade", new Object[0]).func_150261_e());
            } else {
                button.setMessage(new TranslationTextComponent("mininggadgets.tooltip.screen.shrink", new Object[0]).func_150261_e());
            }
            PacketHandler.sendToServer(new PacketChangeBreakType());
        });
        this.addButton((Widget)this.blockBreakButton);
        this.sliderRedInner = new GuiSlider(baseX - 150, baseY - 25, 150, 20, new TranslationTextComponent("mininggadgets.tooltip.screen.red_outer", new Object[0]).func_150261_e() + ": ", "", 0.0, 255.0, (double)this.red, false, true, s -> {}, (GuiSlider.ISlider)this);
        this.sliderGreenInner = new GuiSlider(baseX - 150, baseY + 5, 150, 20, new TranslationTextComponent("mininggadgets.tooltip.screen.green_outer", new Object[0]).func_150261_e() + ": ", "", 0.0, 255.0, (double)this.green, false, true, s -> {}, (GuiSlider.ISlider)this);
        this.sliderBlueInner = new GuiSlider(baseX - 150, baseY + 35, 150, 20, new TranslationTextComponent("mininggadgets.tooltip.screen.blue_outer", new Object[0]).func_150261_e() + ": ", "", 0.0, 255.0, (double)this.blue, false, true, s -> {}, (GuiSlider.ISlider)this);
        this.sliderRedOuter = new GuiSlider(baseX + 25, baseY - 25, 150, 20, new TranslationTextComponent("mininggadgets.tooltip.screen.red_inner", new Object[0]).func_150261_e() + ": ", "", 0.0, 255.0, (double)this.red_inner, false, true, s -> {}, (GuiSlider.ISlider)this);
        this.sliderGreenOuter = new GuiSlider(baseX + 25, baseY + 5, 150, 20, new TranslationTextComponent("mininggadgets.tooltip.screen.green_inner", new Object[0]).func_150261_e() + ": ", "", 0.0, 255.0, (double)this.green_inner, false, true, s -> {}, (GuiSlider.ISlider)this);
        this.sliderBlueOuter = new GuiSlider(baseX + 25, baseY + 35, 150, 20, new TranslationTextComponent("mininggadgets.tooltip.screen.blue_inner", new Object[0]).func_150261_e() + ": ", "", 0.0, 255.0, (double)this.blue_inner, false, true, s -> {}, (GuiSlider.ISlider)this);
        this.addButton((Widget)this.sliderRedInner);
        this.addButton((Widget)this.sliderGreenInner);
        this.addButton((Widget)this.sliderBlueInner);
        this.addButton((Widget)this.sliderRedOuter);
        this.addButton((Widget)this.sliderGreenOuter);
        this.addButton((Widget)this.sliderBlueOuter);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.drawCenteredString(this.getMinecraft().field_71466_p, new TranslationTextComponent("mininggadgets.tooltip.screen.visual_settings", new Object[0]).func_150261_e(), this.width / 2, this.height / 2 - 70, Color.WHITE.getRGB());
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        super.onClose();
        PacketHandler.sendToServer(new PacketChangeColor(this.red, this.green, this.blue, this.red_inner, this.green_inner, this.blue_inner));
    }

    public void onChangeSliderValue(GuiSlider slider) {
        if (slider.equals(this.sliderRedInner)) {
            this.red = slider.getValueInt();
        } else if (slider.equals(this.sliderGreenInner)) {
            this.green = slider.getValueInt();
        } else if (slider.equals(this.sliderBlueInner)) {
            this.blue = slider.getValueInt();
        } else if (slider.equals(this.sliderRedOuter)) {
            this.red_inner = slider.getValueInt();
        } else if (slider.equals(this.sliderGreenOuter)) {
            this.green_inner = slider.getValueInt();
        } else if (slider.equals(this.sliderBlueOuter)) {
            this.blue_inner = slider.getValueInt();
        }
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.sliderRedInner.dragging = false;
        this.sliderGreenInner.dragging = false;
        this.sliderBlueInner.dragging = false;
        this.sliderRedOuter.dragging = false;
        this.sliderGreenOuter.dragging = false;
        this.sliderBlueOuter.dragging = false;
        return false;
    }
}

