/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.containers;

import com.direwolf20.mininggadgets.common.containers.ModificationTableContainer;
import com.direwolf20.mininggadgets.common.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.gadget.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.gadget.upgrade.UpgradeBatteryLevels;
import com.direwolf20.mininggadgets.common.gadget.upgrade.UpgradeTools;
import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.common.items.UpgradeCard;
import com.direwolf20.mininggadgets.common.util.EnergisedItem;
import java.util.List;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.energy.CapabilityEnergy;

public class ModificationTableCommands {
    public static void insertButton(ModificationTableContainer container) {
        Slot laserSlot = (Slot)container.field_75151_b.get(0);
        Slot upgradeSlot = (Slot)container.field_75151_b.get(1);
        ItemStack laser = laserSlot.func_75211_c();
        ItemStack upgradeCard = upgradeSlot.func_75211_c();
        if (laser.func_77973_b() instanceof MiningGadget && upgradeCard.func_77973_b() instanceof UpgradeCard) {
            Upgrade card = ((UpgradeCard)upgradeCard.func_77973_b()).getUpgrade();
            if (card == Upgrade.EMPTY) {
                return;
            }
            List<Upgrade> upgrades = UpgradeTools.getUpgrades(laser);
            boolean hasFortune = UpgradeTools.containsUpgradeFromList(upgrades, Upgrade.FORTUNE_1);
            if (card.getBaseName().equals(Upgrade.RANGE_1.getBaseName())) {
                MiningProperties.setBeamRange(laser, UpgradeTools.getMaxBeamRange(card.getTier()));
                MiningProperties.setBeamMaxRange(laser, UpgradeTools.getMaxBeamRange(card.getTier()));
            }
            if (hasFortune && card == Upgrade.SILK || upgrades.contains((Object)Upgrade.SILK) && card.getBaseName().equals(Upgrade.FORTUNE_1.getBaseName())) {
                return;
            }
            if (UpgradeTools.containsUpgrade(laser, card)) {
                return;
            }
            MiningGadget.applyUpgrade(laser, (UpgradeCard)upgradeCard.func_77973_b());
            if (card.getBaseName().equals(Upgrade.BATTERY_1.getBaseName())) {
                UpgradeBatteryLevels.getBatteryByLevel(card.getTier()).ifPresent(power -> laser.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> ((EnergisedItem)((Object)((Object)e))).updatedMaxEnergy(power.getPower())));
            }
            container.func_75141_a(1, ItemStack.field_190927_a);
        }
    }

    public static void extractButton(ModificationTableContainer container, ServerPlayerEntity player, String upgradeName, boolean isShiftHeld) {
        Slot laserSlot = (Slot)container.field_75151_b.get(0);
        Slot upgradeSlot = (Slot)container.field_75151_b.get(1);
        ItemStack laser = laserSlot.func_75211_c();
        ItemStack upgradeCard = upgradeSlot.func_75211_c();
        if (!(laser.func_77973_b() instanceof MiningGadget) || !upgradeCard.func_190926_b()) {
            return;
        }
        if (!UpgradeTools.containsUpgrades(laser)) {
            return;
        }
        UpgradeTools.getUpgrades(laser).forEach(upgrade -> {
            if (!upgrade.getName().equals(upgradeName)) {
                return;
            }
            UpgradeTools.removeUpgrade(laser, upgrade);
            if (isShiftHeld) {
                boolean success = player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)upgrade.getCard(), 1));
                if (!success) {
                    container.func_75141_a(1, new ItemStack((IItemProvider)upgrade.getCard(), 1));
                }
            } else {
                container.func_75141_a(1, new ItemStack((IItemProvider)upgrade.getCard(), 1));
            }
            if (upgrade == Upgrade.THREE_BY_THREE) {
                MiningProperties.setRange(laser, 1);
            }
            if (upgrade.getBaseName().equals(Upgrade.RANGE_1.getBaseName())) {
                MiningProperties.setBeamRange(laser, 5);
                MiningProperties.setBeamMaxRange(laser, UpgradeTools.getMaxBeamRange(0));
            }
            if (upgrade.getBaseName().equals(Upgrade.BATTERY_1.getBaseName())) {
                laser.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> ((EnergisedItem)((Object)((Object)e))).updatedMaxEnergy(UpgradeBatteryLevels.BATTERY.getPower()));
            }
        });
    }
}

