/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.gadget;

import com.direwolf20.mininggadgets.common.blocks.MinersLight;
import com.direwolf20.mininggadgets.common.blocks.RenderBlock;
import com.direwolf20.mininggadgets.common.tiles.RenderBlockTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class MiningCollect {
    public static List<BlockPos> collect(PlayerEntity player, BlockRayTraceResult startBlock, World world, int range) {
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        BlockPos startPos = startBlock.func_216350_a();
        if (range == 1) {
            if (!MiningCollect.isValid(player, startBlock.func_216350_a(), world)) {
                return coordinates;
            }
            coordinates.add(startBlock.func_216350_a());
            return coordinates;
        }
        Direction side = startBlock.func_216354_b();
        boolean vertical = side.func_176740_k().func_200128_b();
        Direction up = vertical ? player.func_174811_aO() : Direction.UP;
        Direction down = up.func_176734_d();
        Direction right = vertical ? up.func_176746_e() : side.func_176735_f();
        Direction left = right.func_176734_d();
        coordinates.add(startPos.func_177972_a(up).func_177972_a(left));
        coordinates.add(startPos.func_177972_a(up));
        coordinates.add(startPos.func_177972_a(up).func_177972_a(right));
        coordinates.add(startPos.func_177972_a(left));
        coordinates.add(startPos);
        coordinates.add(startPos.func_177972_a(right));
        coordinates.add(startPos.func_177972_a(down).func_177972_a(left));
        coordinates.add(startPos.func_177972_a(down));
        coordinates.add(startPos.func_177972_a(down).func_177972_a(right));
        return coordinates.stream().filter(e -> MiningCollect.isValid(player, e, world)).collect(Collectors.toList());
    }

    private static boolean isValid(PlayerEntity player, BlockPos pos, World world) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof RenderBlock) {
            return true;
        }
        if (!world.func_201675_m().canMineBlock(player, pos)) {
            return false;
        }
        if (!state.func_204520_s().func_206888_e() && !state.func_196959_b((IProperty)BlockStateProperties.field_208198_y) || world.func_175623_d(pos)) {
            return false;
        }
        if (state.func_185887_b((IBlockReader)world, pos) < 0.0f) {
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te != null && !(te instanceof RenderBlockTileEntity)) {
            return false;
        }
        if (state.func_177230_c() instanceof DoorBlock) {
            return false;
        }
        return !(state.func_177230_c() instanceof MinersLight);
    }
}

