/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.items;

import com.direwolf20.mininggadgets.Config;
import com.direwolf20.mininggadgets.MiningGadgets;
import com.direwolf20.mininggadgets.client.particles.playerparticle.PlayerParticleData;
import com.direwolf20.mininggadgets.client.screens.ModScreens;
import com.direwolf20.mininggadgets.common.blocks.ModBlocks;
import com.direwolf20.mininggadgets.common.blocks.RenderBlock;
import com.direwolf20.mininggadgets.common.capabilities.CapabilityEnergyProvider;
import com.direwolf20.mininggadgets.common.gadget.MiningCollect;
import com.direwolf20.mininggadgets.common.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.gadget.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.gadget.upgrade.UpgradeTools;
import com.direwolf20.mininggadgets.common.items.UpgradeCard;
import com.direwolf20.mininggadgets.common.tiles.RenderBlockTileEntity;
import com.direwolf20.mininggadgets.common.util.MiscTools;
import com.direwolf20.mininggadgets.common.util.VectorHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class MiningGadget
extends Item {
    private int energyCapacity;
    private Random rand = new Random();

    public MiningGadget() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(MiningGadgets.itemGroup));
        this.energyCapacity = (Integer)Config.MININGGADGET_MAXPOWER.get();
    }

    public int getMaxDamage(ItemStack stack) {
        return this.energyCapacity;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        return energy.getEnergyStored() < energy.getMaxEnergyStored();
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapabilityEnergyProvider(stack, (Integer)Config.MININGGADGET_MAXPOWER.get());
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        if (energy == null) {
            return 0.0;
        }
        return 1.0 - (double)energy.getEnergyStored() / (double)energy.getMaxEnergyStored();
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        if (energy == null) {
            return super.getRGBDurabilityForDisplay(stack);
        }
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored()) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        List<Upgrade> upgrades = UpgradeTools.getUpgrades(stack);
        Minecraft mc = Minecraft.func_71410_x();
        if (world == null) {
            return;
        }
        if (!InputMappings.func_216506_a((long)mc.field_195558_d.func_198092_i(), (int)mc.field_71474_y.field_74311_E.getKey().func_197937_c())) {
            tooltip.add(new TranslationTextComponent("mininggadgets.tooltip.item.show_upgrades", new Object[]{mc.field_71474_y.field_74311_E.func_197978_k().toLowerCase()}).func_211708_a(TextFormatting.GRAY));
        } else {
            tooltip.add(new TranslationTextComponent("mininggadgets.tooltip.item.break_cost", new Object[]{MiningGadget.getEnergyCost(stack)}).func_211708_a(TextFormatting.RED));
            tooltip.add(new TranslationTextComponent("mininggadgets.tooltip.item.upgrades", new Object[0]).func_211708_a(TextFormatting.AQUA));
            if (!upgrades.isEmpty()) {
                for (Upgrade upgrade : upgrades) {
                    tooltip.add(new StringTextComponent(" - " + I18n.func_135052_a((String)upgrade.getLocal(), (Object[])new Object[0])).func_211708_a(TextFormatting.GRAY));
                }
            }
        }
        stack.getCapability(CapabilityEnergy.ENERGY, null).ifPresent(energy -> tooltip.add(new TranslationTextComponent("mininggadgets.gadget.energy", new Object[]{MiscTools.tidyValue(energy.getEnergyStored()), MiscTools.tidyValue(energy.getMaxEnergyStored())}).func_211709_a(new TextFormatting[]{TextFormatting.GREEN})));
    }

    public static void changeRange(ItemStack tool) {
        if (MiningProperties.getRange(tool) == 1) {
            MiningProperties.setRange(tool, 3);
        } else {
            MiningProperties.setRange(tool, 1);
        }
    }

    public static boolean canMine(ItemStack tool, World world) {
        IEnergyStorage energy = (IEnergyStorage)tool.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        int cost = MiningGadget.getEnergyCost(tool);
        if (MiningProperties.getRange(tool) == 3) {
            cost *= 9;
        }
        return energy.getEnergyStored() > cost;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.NONE;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return true;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            return this.onItemShiftRightClick(world, player, hand, itemstack);
        }
        if (world.field_72995_K) {
            return new ActionResult(ActionResultType.PASS, (Object)itemstack);
        }
        if (!MiningGadget.canMine(itemstack, world)) {
            return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
        }
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.PASS, (Object)itemstack);
    }

    private ActionResult<ItemStack> onItemShiftRightClick(World world, PlayerEntity player, Hand hand, ItemStack itemstack) {
        if (!world.field_72995_K) {
            MiningProperties.setCanMine(itemstack, true);
        }
        if (world.field_72995_K) {
            ModScreens.openGadgetSettingsScreen(itemstack);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    public List<BlockPos> findSources(World world, List<BlockPos> coords) {
        ArrayList<BlockPos> sources = new ArrayList<BlockPos>();
        for (BlockPos coord : coords) {
            for (Direction side : Direction.values()) {
                BlockPos sidePos = coord.func_177972_a(side);
                IFluidState state = world.func_204610_c(sidePos);
                if (!state.func_206886_c().func_207187_a((Fluid)Fluids.field_204547_b) && !state.func_206886_c().func_207187_a((Fluid)Fluids.field_204546_a) || sources.contains(sidePos)) continue;
                sources.add(sidePos);
            }
        }
        return sources;
    }

    private void spawnFreezeParticle(PlayerEntity player, BlockPos sourcePos, World world, ItemStack stack) {
        float randomPartSize = 0.05f + 0.075f * this.rand.nextFloat();
        double randomTX = this.rand.nextDouble();
        double randomTY = this.rand.nextDouble();
        double randomTZ = this.rand.nextDouble();
        double alpha = -0.5 + 0.5 * this.rand.nextDouble();
        Vec3d playerPos = player.func_213303_ch().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        Vec3d look = player.func_70040_Z();
        int range = MiningProperties.getBeamRange(stack);
        BlockRayTraceResult lookAt = VectorHelper.getLookingAt(player, RayTraceContext.FluidMode.NONE, range);
        Vec3d lookingAt = lookAt.func_216347_e();
        Vec3d right = new Vec3d(-look.field_72449_c, 0.0, look.field_72450_a).func_72432_b();
        Vec3d forward = look;
        Vec3d backward = look.func_216372_d(-1.0, 1.0, -1.0);
        Vec3d down = right.func_72431_c(forward);
        right = right.func_186678_a((double)0.65f);
        forward = forward.func_186678_a((double)0.85f);
        down = down.func_186678_a(-0.35);
        backward = backward.func_186678_a(0.05);
        Vec3d laserPos = playerPos.func_178787_e(right);
        laserPos = laserPos.func_178787_e(forward);
        laserPos = laserPos.func_178787_e(down);
        lookingAt = lookingAt.func_178787_e(backward);
        PlayerParticleData data = PlayerParticleData.playerparticle("ice", (double)sourcePos.func_177958_n() + randomTX, (double)sourcePos.func_177956_o() + randomTY, (double)sourcePos.func_177952_p() + randomTZ, randomPartSize, 1.0f, 1.0f, 1.0f, 120.0f, true);
        world.func_195594_a((IParticleData)data, laserPos.field_72450_a, laserPos.field_72448_b, laserPos.field_72449_c, 0.025, (double)0.025f, 0.025);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (!MiningProperties.getCanMine(stack)) {
            return;
        }
        World world = player.field_70170_p;
        int range = MiningProperties.getBeamRange(stack);
        BlockRayTraceResult lookingAt = VectorHelper.getLookingAt((PlayerEntity)player, RayTraceContext.FluidMode.NONE, range);
        if (lookingAt == null || world.func_180495_p(VectorHelper.getLookingAt((PlayerEntity)player, stack, range).func_216350_a()) == Blocks.field_150350_a.func_176223_P()) {
            return;
        }
        List<BlockPos> coords = MiningCollect.collect((PlayerEntity)player, lookingAt, world, MiningProperties.getRange(stack));
        if (UpgradeTools.containsActiveUpgrade(stack, Upgrade.FREEZING)) {
            for (BlockPos sourcePos : this.findSources(player.field_70170_p, coords)) {
                if (!(player instanceof PlayerEntity)) continue;
                this.spawnFreezeParticle((PlayerEntity)player, sourcePos, player.field_70170_p, stack);
            }
        }
        if (!world.field_72995_K) {
            int efficiency = 0;
            if (UpgradeTools.containsActiveUpgrade(stack, Upgrade.EFFICIENCY_1)) {
                efficiency = UpgradeTools.getUpgradeFromGadget(stack, Upgrade.EFFICIENCY_1).get().getTier();
            }
            float hardness = MiningGadget.getHardness(coords, (PlayerEntity)player, efficiency);
            hardness = hardness * (float)MiningProperties.getRange(stack) * 1.0f;
            if ((hardness = (float)Math.floor(hardness)) == 0.0f) {
                hardness = 1.0f;
            }
            for (BlockPos coord : coords) {
                BlockState state = world.func_180495_p(coord);
                if (!(state.func_177230_c() instanceof RenderBlock)) {
                    if (!MiningGadget.canMine(stack, world)) {
                        return;
                    }
                    List<Upgrade> gadgetUpgrades = UpgradeTools.getUpgrades(stack);
                    world.func_175656_a(coord, ((Block)ModBlocks.RENDER_BLOCK.get()).func_176223_P());
                    RenderBlockTileEntity te = (RenderBlockTileEntity)world.func_175625_s(coord);
                    te.setRenderBlock(state);
                    te.setBreakType(MiningProperties.getBreakType(stack));
                    te.setGadgetUpgrades(gadgetUpgrades);
                    te.setGadgetFilters(MiningProperties.getFiltersAsList(stack));
                    te.setGadgetIsWhitelist(MiningProperties.getWhiteList(stack));
                    te.setPriorDurability((int)hardness + 1);
                    te.setOriginalDurability((int)hardness + 1);
                    te.setDurability((int)hardness, stack);
                    te.setPlayer((PlayerEntity)player);
                    te.setBlockAllowed();
                    continue;
                }
                RenderBlockTileEntity te = (RenderBlockTileEntity)world.func_175625_s(coord);
                int durability = te.getDurability();
                if (--durability <= 0) {
                    if (!UpgradeTools.containsUpgrade(stack, Upgrade.HEATSINK)) {
                        player.func_184602_cy();
                    }
                    stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> e.receiveEnergy(MiningGadget.getEnergyCost(stack) * -1, false));
                    if (MiningProperties.getPrecisionMode(stack)) {
                        MiningProperties.setCanMine(stack, false);
                    }
                }
                te.setDurability(durability, stack);
            }
            if (!UpgradeTools.containsActiveUpgrade(stack, Upgrade.LIGHT_PLACER)) {
                return;
            }
            Direction side = lookingAt.func_216354_b();
            boolean vertical = side.func_176740_k().func_200128_b();
            Direction up = vertical ? player.func_174811_aO() : Direction.UP;
            Direction right = vertical ? up.func_176746_e() : side.func_176735_f();
            BlockPos pos = MiningProperties.getRange(stack) == 1 ? lookingAt.func_216350_a().func_177967_a(side, 4) : lookingAt.func_216350_a().func_177972_a(side).func_177972_a(right);
            if (world.func_201696_r(pos) <= 7 && world.func_180495_p(pos).func_185904_a() == Material.field_151579_a) {
                world.func_175656_a(pos, ((Block)ModBlocks.MINERS_LIGHT.get()).func_176223_P());
                stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> e.receiveEnergy((Integer)Config.UPGRADECOST_LIGHT.get() * -1, false));
            }
        }
    }

    public static int getEnergyCost(ItemStack stack) {
        int cost = (Integer)Config.MININGGADGET_BASECOST.get();
        List<Upgrade> upgrades = UpgradeTools.getActiveUpgrades(stack);
        if (upgrades.isEmpty()) {
            return cost;
        }
        return cost + upgrades.stream().mapToInt(Upgrade::getCostPerBlock).sum();
    }

    private static float getHardness(List<BlockPos> coords, PlayerEntity player, int efficiency) {
        EffectInstance hasteEffect;
        float hardness = 0.0f;
        float toolSpeed = 8.0f;
        if (efficiency > 0) {
            toolSpeed += (float)(efficiency * efficiency + 1);
        }
        if ((hasteEffect = player.func_70660_b(Effects.field_76422_e)) != null) {
            int hasteLevel = hasteEffect.func_76458_c() + 1;
            toolSpeed += toolSpeed * ((float)hasteLevel * 20.0f / 100.0f);
        }
        World world = player.func_130014_f_();
        for (BlockPos coord : coords) {
            BlockState state = world.func_180495_p(coord);
            float temphardness = state.func_185887_b((IBlockReader)world, coord);
            hardness += temphardness * 30.0f / toolSpeed;
        }
        return hardness / (float)coords.size();
    }

    public static void applyUpgrade(ItemStack tool, UpgradeCard upgradeCard) {
        if (UpgradeTools.containsUpgrade(tool, upgradeCard.getUpgrade())) {
            return;
        }
        UpgradeTools.setUpgrade(tool, upgradeCard);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity) {
            entityLiving.func_184602_cy();
        }
        if (!worldIn.field_72995_K) {
            MiningProperties.setCanMine(stack, true);
        }
    }

    public static ItemStack getGadget(PlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        if (!(heldItem.func_77973_b() instanceof MiningGadget) && !((heldItem = player.func_184592_cb()).func_77973_b() instanceof MiningGadget)) {
            return ItemStack.field_190927_a;
        }
        return heldItem;
    }
}

