/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.network.packets;

import com.direwolf20.mininggadgets.common.containers.ModificationTableCommands;
import com.direwolf20.mininggadgets.common.containers.ModificationTableContainer;
import com.direwolf20.mininggadgets.common.tiles.ModificationTableTileEntity;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketExtractUpgrade {
    private final BlockPos pos;
    private final String upgrade;
    private final int nameLength;
    private final boolean isShiftHeld;

    public PacketExtractUpgrade(BlockPos blockPos, String upgrade, int nameLength, boolean isShiftHeld) {
        this.pos = blockPos;
        this.upgrade = upgrade;
        this.nameLength = nameLength;
        this.isShiftHeld = isShiftHeld;
    }

    public static void encode(PacketExtractUpgrade msg, PacketBuffer buffer) {
        buffer.writeInt(msg.nameLength);
        buffer.func_179255_a(msg.pos);
        buffer.func_180714_a(msg.upgrade);
        buffer.writeBoolean(msg.isShiftHeld);
    }

    public static PacketExtractUpgrade decode(PacketBuffer buffer) {
        int strLength = buffer.readInt();
        return new PacketExtractUpgrade(buffer.func_179259_c(), buffer.func_150789_c(strLength), strLength, buffer.readBoolean());
    }

    public static class Handler {
        public static void handle(PacketExtractUpgrade msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    return;
                }
                World world = player.field_70170_p;
                BlockPos pos = msg.pos;
                TileEntity te = world.func_175625_s(pos);
                if (!(te instanceof ModificationTableTileEntity)) {
                    return;
                }
                ModificationTableContainer container = ((ModificationTableTileEntity)te).getContainer((PlayerEntity)player);
                ModificationTableCommands.extractButton(container, player, msg.upgrade, msg.isShiftHeld);
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

