/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.util;

import com.direwolf20.mininggadgets.common.blocks.ModBlocks;
import com.direwolf20.mininggadgets.common.gadget.MiningCollect;
import com.direwolf20.mininggadgets.common.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.util.VectorHelper;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class BlockOverlayRender {
    public static void render(ItemStack item) {
        Minecraft mc = Minecraft.func_71410_x();
        int range = MiningProperties.getBeamRange(item);
        BlockRayTraceResult lookingAt = VectorHelper.getLookingAt((PlayerEntity)mc.field_71439_g, RayTraceContext.FluidMode.NONE, range);
        if (mc.field_71441_e.func_180495_p(VectorHelper.getLookingAt((PlayerEntity)mc.field_71439_g, item, range).func_216350_a()) == Blocks.field_150350_a.func_176223_P()) {
            return;
        }
        List<BlockPos> coords = MiningCollect.collect((PlayerEntity)mc.field_71439_g, lookingAt, (World)mc.field_71441_e, MiningProperties.getRange(item));
        Vec3d playerPos = new Vec3d(TileEntityRendererDispatcher.field_147554_b, TileEntityRendererDispatcher.field_147555_c, TileEntityRendererDispatcher.field_147552_d);
        GlStateManager.pushMatrix();
        GlStateManager.enableBlend();
        GlStateManager.disableTexture();
        GlStateManager.translated((double)(-playerPos.func_82615_a()), (double)(-playerPos.func_82617_b()), (double)(-playerPos.func_82616_c()));
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        coords.forEach(e -> {
            if (mc.field_71441_e.func_180495_p(e).func_177230_c() != ModBlocks.RENDER_BLOCK.get()) {
                GlStateManager.pushMatrix();
                GlStateManager.translatef((float)e.func_177958_n(), (float)e.func_177956_o(), (float)e.func_177952_p());
                GlStateManager.translatef((float)-0.005f, (float)-0.005f, (float)-0.005f);
                GlStateManager.scalef((float)1.01f, (float)1.01f, (float)1.01f);
                GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                BlockOverlayRender.render(e, tessellator, buffer, Color.GREEN);
                GlStateManager.popMatrix();
            }
        });
        GlStateManager.disableBlend();
        GlStateManager.enableTexture();
        GlStateManager.popMatrix();
    }

    public static void render(BlockPos pos, Tessellator tessellator, BufferBuilder buffer, Color color) {
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        double maxX = pos.func_177958_n() + 1;
        double maxY = pos.func_177956_o() + 1;
        double maxZ = pos.func_177952_p() + 1;
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = 0.125f;
        double startX = 0.0;
        double startY = 0.0;
        double startZ = -1.0;
        double endX = 1.0;
        double endY = 1.0;
        double endZ = 0.0;
        buffer.func_181662_b(startX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(endX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(endX, startY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(startX, startY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(startX, endY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(startX, endY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(endX, endY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(endX, endY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(startX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(startX, endY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(endX, endY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(endX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(startX, startY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(endX, startY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(endX, endY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(startX, endY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(endX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(endX, endY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(endX, endY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(endX, startY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(startX, startY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(startX, startY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(startX, endY, endZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(startX, endY, startZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
    }
}

