/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.renderer;

import com.direwolf20.mininggadgets.client.renderer.MyRenderType;
import com.direwolf20.mininggadgets.common.blocks.ModBlocks;
import com.direwolf20.mininggadgets.common.items.gadget.MiningCollect;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.util.VectorHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;

public class BlockOverlayRender {
    public static void render(RenderWorldLastEvent event, ItemStack item) {
        Minecraft mc = Minecraft.func_71410_x();
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        int range = MiningProperties.getBeamRange(item);
        BlockRayTraceResult lookingAt = VectorHelper.getLookingAt((PlayerEntity)mc.field_71439_g, RayTraceContext.FluidMode.NONE, range);
        if (mc.field_71441_e.func_180495_p(VectorHelper.getLookingAt((PlayerEntity)mc.field_71439_g, item, range).func_216350_a()) == Blocks.field_150350_a.func_176223_P()) {
            return;
        }
        List<BlockPos> coords = MiningCollect.collect((PlayerEntity)mc.field_71439_g, lookingAt, (World)mc.field_71441_e, MiningProperties.getRange(item));
        Vec3d view = mc.field_71460_t.func_215316_n().func_216785_c();
        MatrixStack matrix = event.getMatrixStack();
        matrix.func_227860_a_();
        matrix.func_227861_a_(-view.func_82615_a(), -view.func_82617_b(), -view.func_82616_c());
        IVertexBuilder builder = buffer.getBuffer(MyRenderType.BlockOverlay);
        coords.forEach(e -> {
            if (mc.field_71441_e.func_180495_p(e).func_177230_c() != ModBlocks.RENDER_BLOCK.get()) {
                matrix.func_227860_a_();
                matrix.func_227861_a_((double)e.func_177958_n(), (double)e.func_177956_o(), (double)e.func_177952_p());
                matrix.func_227861_a_((double)-0.005f, (double)-0.005f, (double)-0.005f);
                matrix.func_227862_a_(1.01f, 1.01f, 1.01f);
                matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                Matrix4f positionMatrix = matrix.func_227866_c_().func_227870_a_();
                BlockOverlayRender.render(positionMatrix, builder, e, Color.GREEN);
                matrix.func_227865_b_();
            }
        });
        matrix.func_227865_b_();
        RenderSystem.disableDepthTest();
        buffer.func_228462_a_(MyRenderType.BlockOverlay);
    }

    public static void render(Matrix4f matrix, IVertexBuilder builder, BlockPos pos, Color color) {
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = 0.125f;
        float startX = 0.0f;
        float startY = 0.0f;
        float startZ = -1.0f;
        float endX = 1.0f;
        float endY = 1.0f;
        float endZ = 0.0f;
        builder.func_227888_a_(matrix, startX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
    }
}

