/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.particles.laserparticle;

import com.direwolf20.mininggadgets.client.particles.ModParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;

public class LaserParticleData
implements IParticleData {
    public final float size;
    public final float r;
    public final float g;
    public final float b;
    public final float maxAgeMul;
    public final boolean depthTest;
    public final BlockState state;
    public static final IParticleData.IDeserializer<LaserParticleData> DESERIALIZER = new IParticleData.IDeserializer<LaserParticleData>(){

        @Nonnull
        public LaserParticleData deserialize(@Nonnull ParticleType<LaserParticleData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            BlockState state = new BlockStateParser(reader, false).func_197243_a(false).func_197249_b();
            reader.expect(' ');
            float size = reader.readFloat();
            reader.expect(' ');
            float r = reader.readFloat();
            reader.expect(' ');
            float g = reader.readFloat();
            reader.expect(' ');
            float b = reader.readFloat();
            reader.expect(' ');
            float mam = reader.readFloat();
            boolean depth = true;
            if (reader.canRead()) {
                reader.expect(' ');
                depth = reader.readBoolean();
            }
            return new LaserParticleData(state, size, r, g, b, mam, depth);
        }

        public LaserParticleData read(@Nonnull ParticleType<LaserParticleData> type, PacketBuffer buf) {
            return new LaserParticleData((BlockState)Block.field_176229_d.func_148745_a(buf.func_150792_a()), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readBoolean());
        }
    };

    public static LaserParticleData laserparticle(BlockState state, float size, float r, float g, float b) {
        return LaserParticleData.laserparticle(state, size, r, g, b, 1.0f);
    }

    public static LaserParticleData laserparticle(BlockState state, float size, float r, float g, float b, float maxAgeMul) {
        return LaserParticleData.laserparticle(state, size, r, g, b, maxAgeMul, true);
    }

    public static LaserParticleData laserparticle(BlockState state, float size, float r, float g, float b, boolean depth) {
        return LaserParticleData.laserparticle(state, size, r, g, b, 1.0f, depth);
    }

    public static LaserParticleData laserparticle(BlockState state, float size, float r, float g, float b, float maxAgeMul, boolean depthTest) {
        return new LaserParticleData(state, size, r, g, b, maxAgeMul, depthTest);
    }

    private LaserParticleData(BlockState state, float size, float r, float g, float b, float maxAgeMul, boolean depthTest) {
        this.size = size;
        this.r = r;
        this.g = g;
        this.b = b;
        this.maxAgeMul = maxAgeMul;
        this.depthTest = depthTest;
        this.state = state;
    }

    @Nonnull
    public ParticleType<LaserParticleData> func_197554_b() {
        return ModParticles.LASERPARTICLE;
    }

    public void func_197553_a(PacketBuffer buf) {
        buf.func_150787_b(Block.field_176229_d.func_148757_b((Object)this.state));
        buf.writeFloat(this.size);
        buf.writeFloat(this.r);
        buf.writeFloat(this.g);
        buf.writeFloat(this.b);
        buf.writeFloat(this.maxAgeMul);
        buf.writeBoolean(this.depthTest);
    }

    @Nonnull
    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f %s", this.func_197554_b().getRegistryName(), Float.valueOf(this.size), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.maxAgeMul), this.depthTest);
    }
}

