/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.screens;

import com.direwolf20.mininggadgets.client.screens.ModScreens;
import com.direwolf20.mininggadgets.client.screens.widget.ToggleButton;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.items.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.items.upgrade.UpgradeTools;
import com.direwolf20.mininggadgets.common.network.PacketHandler;
import com.direwolf20.mininggadgets.common.network.packets.PacketChangeFreezeDelay;
import com.direwolf20.mininggadgets.common.network.packets.PacketChangeMiningSize;
import com.direwolf20.mininggadgets.common.network.packets.PacketChangeRange;
import com.direwolf20.mininggadgets.common.network.packets.PacketChangeVolume;
import com.direwolf20.mininggadgets.common.network.packets.PacketOpenFilterContainer;
import com.direwolf20.mininggadgets.common.network.packets.PacketToggleFilters;
import com.direwolf20.mininggadgets.common.network.packets.PacketTogglePrecision;
import com.direwolf20.mininggadgets.common.network.packets.PacketUpdateUpgrade;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.util.InputMappings;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.widget.Slider;

public class MiningSettingScreen
extends Screen
implements Slider.ISlider {
    private ItemStack gadget;
    private int beamRange;
    private int freezeDelay;
    private float volume;
    private int currentSize = 1;
    private boolean isWhitelist = true;
    private boolean isPrecision = true;
    private Slider rangeSlider;
    private Slider volumeSlider;
    private Slider freezeDelaySlider;
    private List<Upgrade> toggleableList = new ArrayList<Upgrade>();
    private HashMap<Upgrade, ToggleButton> upgradeButtons = new HashMap();
    private boolean containsFreeze = false;

    public MiningSettingScreen(ItemStack gadget) {
        super((ITextComponent)new StringTextComponent("title"));
        this.gadget = gadget;
        this.beamRange = MiningProperties.getBeamRange(gadget);
        this.volume = MiningProperties.getVolume(gadget);
        this.freezeDelay = MiningProperties.getFreezeDelay(gadget);
    }

    protected void func_231160_c_() {
        ArrayList<Object> leftWidgets = new ArrayList<Object>();
        int baseX = this.field_230708_k_ / 2;
        int baseY = this.field_230709_l_ / 2;
        this.toggleableList.clear();
        this.toggleableList = UpgradeTools.getUpgrades(this.gadget).stream().filter(Upgrade::isToggleable).collect(Collectors.toList());
        this.containsFreeze = UpgradeTools.containsUpgradeFromList(this.toggleableList, Upgrade.FREEZING);
        boolean containsVoid = UpgradeTools.containsUpgradeFromList(this.toggleableList, Upgrade.VOID_JUNK);
        this.isWhitelist = MiningProperties.getWhiteList(this.gadget);
        this.isPrecision = MiningProperties.getPrecisionMode(this.gadget);
        int top = baseY - (this.containsFreeze ? 80 : 60);
        int index = 0;
        int x = baseX + 10;
        int y = top + (containsVoid ? 45 : 20);
        for (Upgrade upgrade : this.toggleableList) {
            ToggleButton btn = new ToggleButton(x + index * 30, y, UpgradeTools.getName(upgrade), new ResourceLocation("mininggadgets", "textures/item/upgrade_" + upgrade.getName() + ".png"), send -> this.toggleUpgrade(upgrade, (boolean)send));
            this.func_230480_a_(btn);
            this.upgradeButtons.put(upgrade, btn);
            if (++index % 4 != 0) continue;
            index = 0;
            y += 35;
        }
        if (containsVoid) {
            this.func_230480_a_((Widget)new Button(baseX + 10, top + 20, 95, 20, (ITextComponent)MiningSettingScreen.getTrans("tooltip.screen.edit_filters", new Object[0]), button -> PacketHandler.sendToServer(new PacketOpenFilterContainer())));
            this.func_230480_a_((Widget)new WhitelistButton(baseX + 10 + 95, top + 20, 20, 20, this.isWhitelist, button -> {
                this.isWhitelist = !this.isWhitelist;
                ((WhitelistButton)button).setWhitelist(this.isWhitelist);
                PacketHandler.sendToServer(new PacketToggleFilters());
            }));
        }
        this.currentSize = MiningProperties.getRange(this.gadget);
        Button sizeButton = new Button(baseX - 135, 0, 125, 20, (ITextComponent)new TranslationTextComponent("mininggadgets.tooltip.screen.size", new Object[]{this.currentSize}), button -> {
            this.currentSize = this.currentSize == 1 ? 3 : 1;
            button.func_238482_a_((ITextComponent)MiningSettingScreen.getTrans("tooltip.screen.size", this.currentSize));
            PacketHandler.sendToServer(new PacketChangeMiningSize());
        });
        leftWidgets.add(sizeButton);
        this.rangeSlider = new Slider(baseX - 135, 0, 125, 20, (ITextComponent)MiningSettingScreen.getTrans("tooltip.screen.range", new Object[0]).func_240702_b_(": "), StringTextComponent.field_240750_d_, 1.0, (double)MiningProperties.getBeamMaxRange(this.gadget), (double)this.beamRange, false, true, s -> {}, (Slider.ISlider)this);
        leftWidgets.add(this.rangeSlider);
        leftWidgets.add(new Button(baseX - 135, 0, 125, 20, (ITextComponent)MiningSettingScreen.getTrans("tooltip.screen.visuals_menu", new Object[0]), button -> ModScreens.openVisualSettingsScreen(this.gadget)));
        leftWidgets.add(new Button(baseX - 135, 0, 125, 20, (ITextComponent)MiningSettingScreen.getTrans("tooltip.screen.precision_mode", this.isPrecision), button -> {
            this.isPrecision = !this.isPrecision;
            button.func_238482_a_((ITextComponent)MiningSettingScreen.getTrans("tooltip.screen.precision_mode", this.isPrecision));
            PacketHandler.sendToServer(new PacketTogglePrecision());
        }));
        this.volumeSlider = new Slider(baseX - 135, 0, 125, 20, (ITextComponent)MiningSettingScreen.getTrans("tooltip.screen.volume", new Object[0]).func_240702_b_(": "), (ITextComponent)new StringTextComponent("%"), 0.0, 100.0, (double)Math.min(100.0f, this.volume * 100.0f), false, true, s -> {}, (Slider.ISlider)this);
        leftWidgets.add(this.volumeSlider);
        if (this.containsFreeze) {
            this.freezeDelaySlider = new Slider(baseX - 135, 0, 125, 20, (ITextComponent)MiningSettingScreen.getTrans("tooltip.screen.freeze_delay", new Object[0]).func_240702_b_(": "), (ITextComponent)new StringTextComponent(" ").func_230529_a_((ITextComponent)MiningSettingScreen.getTrans("tooltip.screen.ticks", new Object[0])), 0.0, 10.0, (double)MiningProperties.getFreezeDelay(this.gadget), false, true, s -> {}, (Slider.ISlider)this);
            leftWidgets.add(this.freezeDelaySlider);
        }
        if (!UpgradeTools.containsActiveUpgrade(this.gadget, Upgrade.THREE_BY_THREE)) {
            sizeButton.field_230693_o_ = false;
        }
        for (int i = 0; i < leftWidgets.size(); ++i) {
            ((Widget)leftWidgets.get((int)i)).field_230691_m_ = top + 20 + i * 25;
            this.func_230480_a_((Widget)leftWidgets.get(i));
        }
    }

    private boolean toggleUpgrade(Upgrade upgrade, boolean update) {
        if (update) {
            this.updateButtons(upgrade);
            PacketHandler.sendToServer(new PacketUpdateUpgrade(upgrade.getName()));
        }
        return upgrade.isEnabled();
    }

    private void updateButtons(Upgrade upgrade) {
        for (Map.Entry<Upgrade, ToggleButton> btn : this.upgradeButtons.entrySet()) {
            Upgrade btnUpgrade = btn.getKey();
            if ((!btnUpgrade.lazyIs(Upgrade.FORTUNE_1) || !btn.getValue().isEnabled() || !upgrade.lazyIs(Upgrade.SILK)) && (!btnUpgrade.lazyIs(Upgrade.SILK) || !btn.getValue().isEnabled() || !upgrade.lazyIs(Upgrade.FORTUNE_1))) continue;
            this.upgradeButtons.get((Object)btn.getKey()).setEnabled(false);
        }
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        int top = this.field_230709_l_ / 2 - (this.containsFreeze ? 80 : 60);
        MiningSettingScreen.func_238475_b_((MatrixStack)stack, (FontRenderer)this.getMinecraft().field_71466_p, (ITextComponent)MiningSettingScreen.getTrans("tooltip.screen.mining_gadget", new Object[0]), (int)(this.field_230708_k_ / 2 - 135), (int)top, (int)Color.WHITE.getRGB());
        MiningSettingScreen.func_238475_b_((MatrixStack)stack, (FontRenderer)this.getMinecraft().field_71466_p, (ITextComponent)MiningSettingScreen.getTrans("tooltip.screen.toggle_upgrades", new Object[0]), (int)(this.field_230708_k_ / 2 + 10), (int)top, (int)Color.WHITE.getRGB());
        if (this.toggleableList.size() == 0) {
            MiningSettingScreen.func_238475_b_((MatrixStack)stack, (FontRenderer)this.getMinecraft().field_71466_p, (ITextComponent)MiningSettingScreen.getTrans("tooltip.screen.no_upgrades", new Object[0]), (int)(this.field_230708_k_ / 2 + 10), (int)(top + 20), (int)Color.GRAY.getRGB());
        }
        this.field_230705_e_.forEach(e -> {
            if (!(e instanceof ToggleButton || e instanceof WhitelistButton || e.equals(this.freezeDelaySlider))) {
                return;
            }
            if (e instanceof WhitelistButton) {
                if (e.func_231047_b_((double)mouseX, (double)mouseY)) {
                    this.func_238652_a_(stack, (ITextComponent)(this.isWhitelist ? MiningSettingScreen.getTrans("tooltip.screen.whitelist", new Object[0]) : MiningSettingScreen.getTrans("tooltip.screen.blacklist", new Object[0])), mouseX, mouseY);
                }
            } else if (e.equals(this.freezeDelaySlider)) {
                if (e.func_231047_b_((double)mouseX, (double)mouseY)) {
                    assert (e instanceof Slider);
                    List helpText = Arrays.stream(MiningSettingScreen.getTrans("tooltip.screen.delay_explain", new Object[0]).getString().split("\n")).map(StringTextComponent::new).collect(Collectors.toList());
                    this.func_238654_b_(stack, LanguageMap.func_74808_a().func_244260_a(helpText), ((Slider)e).field_230690_l_ - 8, ((Slider)e).field_230691_m_ + 40);
                }
            } else {
                assert (e instanceof ToggleButton);
                ToggleButton btn = (ToggleButton)((Object)e);
                if (btn.func_231047_b_(mouseX, mouseY)) {
                    this.func_238654_b_(stack, btn.getTooltip(), mouseX, mouseY);
                }
            }
        });
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_231164_f_() {
        PacketHandler.sendToServer(new PacketChangeRange(this.beamRange));
        PacketHandler.sendToServer(new PacketChangeVolume(this.volume));
        PacketHandler.sendToServer(new PacketChangeFreezeDelay(this.freezeDelay));
        super.func_231164_f_();
    }

    public boolean func_231046_a_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (p_keyPressed_1_ == 256 || this.field_230706_i_.field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey)) {
            this.func_231175_as__();
            return true;
        }
        return super.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void onChangeSliderValue(Slider slider) {
        if (slider.equals(this.rangeSlider)) {
            this.beamRange = slider.getValueInt();
        }
        if (slider.equals(this.freezeDelaySlider)) {
            this.freezeDelay = slider.getValueInt();
        }
        if (slider.equals(this.volumeSlider)) {
            this.volume = (float)slider.getValueInt() / 100.0f;
        }
    }

    public boolean func_231048_c_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.rangeSlider.dragging = false;
        this.volumeSlider.dragging = false;
        if (this.freezeDelaySlider != null) {
            this.freezeDelaySlider.dragging = false;
        }
        return false;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (this.rangeSlider.func_231047_b_(mouseX, mouseY)) {
            this.rangeSlider.sliderValue = this.rangeSlider.sliderValue + (double)(0.1f * (float)(delta > 0.0 ? 1 : -1));
            this.rangeSlider.updateSlider();
        }
        if (this.freezeDelaySlider.func_231047_b_(mouseX, mouseY)) {
            this.freezeDelaySlider.sliderValue = this.freezeDelaySlider.sliderValue + (double)(0.1f * (float)(delta > 0.0 ? 1 : -1));
            this.freezeDelaySlider.updateSlider();
        }
        if (this.volumeSlider.func_231047_b_(mouseX, mouseY)) {
            this.volumeSlider.sliderValue = this.volumeSlider.sliderValue + (double)(1.0f * (float)(delta > 0.0 ? 1 : -1));
            this.volumeSlider.updateSlider();
        }
        return false;
    }

    private static TranslationTextComponent getTrans(String key, Object ... args) {
        return new TranslationTextComponent("mininggadgets." + key, args);
    }

    public static final class WhitelistButton
    extends Button {
        private boolean isWhitelist;

        public WhitelistButton(int widthIn, int heightIn, int width, int height, boolean isWhitelist, Button.IPressable onPress) {
            super(widthIn, heightIn, width, height, StringTextComponent.field_240750_d_, onPress);
            this.isWhitelist = isWhitelist;
        }

        public void func_230431_b_(MatrixStack stack, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
            RenderSystem.disableTexture();
            RenderSystem.color4f((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
            this.func_238474_b_(stack, this.field_230690_l_, this.field_230691_m_, 0, 0, this.field_230688_j_, this.field_230689_k_);
            if (this.isWhitelist) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            this.func_238474_b_(stack, this.field_230690_l_ + 2, this.field_230691_m_ + 2, 0, 0, this.field_230688_j_ - 4, this.field_230689_k_ - 4);
            RenderSystem.enableTexture();
        }

        public void setWhitelist(boolean whitelist) {
            this.isWhitelist = whitelist;
        }
    }
}

