/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.tiles;

import com.direwolf20.mininggadgets.client.particles.laserparticle.LaserParticleData;
import com.direwolf20.mininggadgets.common.Config;
import com.direwolf20.mininggadgets.common.blocks.ModBlocks;
import com.direwolf20.mininggadgets.common.events.ServerTickHandler;
import com.direwolf20.mininggadgets.common.items.ModItems;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.items.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.items.upgrade.UpgradeTools;
import com.direwolf20.mininggadgets.common.util.SpecialBlockActions;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.event.ForgeEventFactory;

public class RenderBlockTileEntity
extends TileEntity
implements ITickableTileEntity {
    private BlockState renderBlock;
    private int priorDurability = 9999;
    private int clientPrevDurability;
    private int clientDurability;
    private int durability;
    private UUID playerUUID;
    private int originalDurability;
    private Random rand = new Random();
    private int ticksSinceMine = 0;
    private List<Upgrade> gadgetUpgrades;
    private List<ItemStack> gadgetFilters;
    private boolean gadgetIsWhitelist;
    private boolean packetReceived = false;
    private int totalAge;
    private MiningProperties.BreakTypes breakType;
    private boolean blockAllowed;

    public RenderBlockTileEntity() {
        super((TileEntityType)ModBlocks.RENDERBLOCK_TILE.get());
    }

    public void setRenderBlock(BlockState state) {
        this.renderBlock = state;
    }

    public BlockState getRenderBlock() {
        return this.renderBlock;
    }

    public MiningProperties.BreakTypes getBreakType() {
        return this.breakType;
    }

    public void setBreakType(MiningProperties.BreakTypes breakType) {
        this.breakType = breakType;
    }

    public void justSetDurability(int durability) {
        this.priorDurability = this.durability;
        this.durability = durability;
    }

    public void setDurability(int dur, ItemStack stack) {
        this.ticksSinceMine = 0;
        if (this.durability != 0) {
            this.priorDurability = this.durability;
        }
        this.durability = dur;
        if (dur <= 0) {
            this.removeBlock();
            if (UpgradeTools.containsActiveUpgradeFromList(this.gadgetUpgrades, Upgrade.FREEZING)) {
                this.freeze(stack);
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            this.func_70296_d();
            ServerTickHandler.addToList(this.field_174879_c, this.durability, this.field_145850_b);
        }
    }

    private void freeze(ItemStack stack) {
        for (Direction side : Direction.values()) {
            BlockPos sidePos = this.field_174879_c.func_177972_a(side);
            FluidState state = this.field_145850_b.func_204610_c(sidePos);
            int freezeCost = (Integer)Config.UPGRADECOST_FREEZE.get() * -1;
            if (state.func_206886_c().func_207187_a((Fluid)Fluids.field_204547_b) && state.func_206886_c().func_207193_c(state)) {
                this.field_145850_b.func_175656_a(sidePos, Blocks.field_150343_Z.func_176223_P());
                stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> e.receiveEnergy(freezeCost, false));
                continue;
            }
            if (state.func_206886_c().func_207187_a((Fluid)Fluids.field_204546_a) && state.func_206886_c().func_207193_c(state)) {
                this.field_145850_b.func_175656_a(sidePos, Blocks.field_150403_cj.func_176223_P());
                stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> e.receiveEnergy(freezeCost, false));
                continue;
            }
            if (!state.func_206886_c().func_207187_a((Fluid)Fluids.field_204546_a) && !state.func_206886_c().func_207187_a((Fluid)Fluids.field_204547_b) || state.func_206886_c().func_207193_c(state)) continue;
            this.field_145850_b.func_175656_a(sidePos, Blocks.field_150347_e.func_176223_P());
            stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> e.receiveEnergy(freezeCost, false));
        }
    }

    public void spawnParticle() {
        if (UpgradeTools.containsActiveUpgradeFromList(this.gadgetUpgrades, Upgrade.MAGNET) && this.originalDurability > 0) {
            int PartCount = 20 / this.originalDurability;
            if (PartCount <= 1) {
                PartCount = 1;
            }
            for (int i = 0; i <= PartCount; ++i) {
                double randomPartSize = 0.125 + this.rand.nextDouble() * 0.5;
                double randomX = this.rand.nextDouble();
                double randomY = this.rand.nextDouble();
                double randomZ = this.rand.nextDouble();
                LaserParticleData data = LaserParticleData.laserparticle(this.renderBlock, (float)randomPartSize, 1.0f, 1.0f, 1.0f, 200.0f);
                this.func_145831_w().func_195594_a((IParticleData)data, (double)this.func_174877_v().func_177958_n() + randomX, (double)this.func_174877_v().func_177956_o() + randomY, (double)this.func_174877_v().func_177952_p() + randomZ, 0.0, 0.0, 0.0);
            }
        }
    }

    public int getDurability() {
        return this.durability;
    }

    public int getOriginalDurability() {
        return this.originalDurability;
    }

    public void setOriginalDurability(int originalDurability) {
        this.originalDurability = originalDurability;
    }

    public PlayerEntity getPlayer() {
        if (this.func_145831_w() == null) {
            return null;
        }
        return this.func_145831_w().func_217371_b(this.playerUUID);
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public void setPlayer(PlayerEntity player) {
        this.playerUUID = player.func_110124_au();
    }

    public int getTicksSinceMine() {
        return this.ticksSinceMine;
    }

    public void setTicksSinceMine(int ticksSinceMine) {
        this.ticksSinceMine = ticksSinceMine;
    }

    public int getPriorDurability() {
        return this.priorDurability;
    }

    public void setPriorDurability(int priorDurability) {
        this.priorDurability = priorDurability;
    }

    public int getClientDurability() {
        return this.clientDurability;
    }

    public void setClientDurability(int clientDurability) {
        this.clientPrevDurability = this.durability == 0 ? clientDurability : this.durability;
        this.clientDurability = clientDurability;
        this.packetReceived = true;
    }

    public List<Upgrade> getGadgetUpgrades() {
        return this.gadgetUpgrades;
    }

    public void setGadgetUpgrades(List<Upgrade> gadgetUpgrades) {
        this.gadgetUpgrades = gadgetUpgrades;
    }

    public List<ItemStack> getGadgetFilters() {
        return this.gadgetFilters;
    }

    public void setGadgetFilters(List<ItemStack> gadgetFilters) {
        this.gadgetFilters = gadgetFilters;
    }

    public boolean isGadgetIsWhitelist() {
        return this.gadgetIsWhitelist;
    }

    public void setGadgetIsWhitelist(boolean gadgetIsWhitelist) {
        this.gadgetIsWhitelist = gadgetIsWhitelist;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public void markDirtyClient() {
        this.func_70296_d();
        if (this.func_145831_w() != null) {
            BlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.renderBlock = NBTUtil.func_190008_d((CompoundNBT)tag.func_74775_l("renderBlock"));
        this.originalDurability = tag.func_74762_e("originalDurability");
        this.priorDurability = tag.func_74762_e("priorDurability");
        this.durability = tag.func_74762_e("durability");
        this.ticksSinceMine = tag.func_74762_e("ticksSinceMine");
        this.playerUUID = tag.func_186857_a("playerUUID");
        this.gadgetUpgrades = UpgradeTools.getUpgradesFromTag(tag);
        this.breakType = MiningProperties.BreakTypes.values()[tag.func_74771_c("breakType")];
        this.gadgetFilters = MiningProperties.deserializeItemStackList(tag.func_74775_l("gadgetFilters"));
        this.gadgetIsWhitelist = tag.func_74767_n("gadgetIsWhitelist");
        this.blockAllowed = tag.func_74767_n("blockAllowed");
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        if (this.renderBlock != null) {
            tag.func_218657_a("renderBlock", (INBT)NBTUtil.func_190009_a((BlockState)this.renderBlock));
        }
        tag.func_74768_a("originalDurability", this.originalDurability);
        tag.func_74768_a("priorDurability", this.priorDurability);
        tag.func_74768_a("durability", this.durability);
        tag.func_74768_a("ticksSinceMine", this.ticksSinceMine);
        if (this.playerUUID != null) {
            tag.func_186854_a("playerUUID", this.playerUUID);
        }
        tag.func_218657_a("upgrades", (INBT)UpgradeTools.setUpgradesNBT(this.gadgetUpgrades).func_150295_c("upgrades", 10));
        tag.func_74774_a("breakType", (byte)this.breakType.ordinal());
        tag.func_218657_a("gadgetFilters", (INBT)MiningProperties.serializeItemStackList(this.getGadgetFilters()));
        tag.func_74757_a("gadgetIsWhitelist", this.isGadgetIsWhitelist());
        tag.func_74757_a("blockAllowed", this.blockAllowed);
        return super.func_189515_b(tag);
    }

    private void removeBlock() {
        Optional<Upgrade> upgrade;
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K || this.playerUUID == null || this.playerUUID.equals(null)) {
            return;
        }
        PlayerEntity player = this.field_145850_b.func_217371_b(this.playerUUID);
        if (player == null) {
            return;
        }
        int silk = 0;
        int fortune = 0;
        ItemStack tempTool = new ItemStack((IItemProvider)ModItems.MININGGADGET.get());
        if (UpgradeTools.containsActiveUpgradeFromList(this.gadgetUpgrades, Upgrade.SILK)) {
            tempTool.func_77966_a(Enchantments.field_185306_r, 1);
            silk = 1;
        }
        if (UpgradeTools.containsActiveUpgradeFromList(this.gadgetUpgrades, Upgrade.FORTUNE_1) && (upgrade = UpgradeTools.getUpgradeFromList(this.gadgetUpgrades, Upgrade.FORTUNE_1)).isPresent()) {
            fortune = upgrade.get().getTier();
            tempTool.func_77966_a(Enchantments.field_185308_t, fortune);
        }
        List drops = Block.func_220077_a((BlockState)this.renderBlock, (ServerWorld)((ServerWorld)this.field_145850_b), (BlockPos)this.field_174879_c, null, (Entity)player, (ItemStack)tempTool);
        if (this.blockAllowed) {
            int exp = this.renderBlock.getExpDrop((IWorldReader)this.field_145850_b, this.field_174879_c, fortune, silk);
            boolean magnetMode = UpgradeTools.containsActiveUpgradeFromList(this.gadgetUpgrades, Upgrade.MAGNET);
            for (ItemStack drop : drops) {
                if (drop == null) continue;
                if (magnetMode) {
                    int wasPickedUp = ForgeEventFactory.onItemPickup((ItemEntity)new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), drop), (PlayerEntity)player);
                    if (wasPickedUp != 0 || player.func_191521_c(drop)) continue;
                    Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)drop);
                    continue;
                }
                Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)drop);
            }
            if (magnetMode) {
                if (exp > 0) {
                    player.func_195068_e(exp);
                }
            } else if (exp > 0) {
                this.renderBlock.func_177230_c().func_180637_b((ServerWorld)this.field_145850_b, this.field_174879_c, exp);
            }
            this.renderBlock.func_215706_a((ServerWorld)this.field_145850_b, this.field_174879_c, tempTool);
        }
        this.field_145850_b.func_175713_t(this.field_174879_c);
        this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
        player.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)this.renderBlock.func_177230_c()));
        if (SpecialBlockActions.getRegister().containsKey(this.renderBlock.func_177230_c())) {
            SpecialBlockActions.getRegister().get(this.renderBlock.func_177230_c()).accept((Object)this.field_145850_b, (Object)this.field_174879_c, (Object)this.renderBlock);
        }
    }

    private void resetBlock() {
        if (this.field_145850_b == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.renderBlock != null) {
                this.field_145850_b.func_175656_a(this.field_174879_c, this.renderBlock);
            } else {
                this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
            }
        }
    }

    public void func_73660_a() {
        ++this.totalAge;
        if (this.ticksSinceMine == 0) {
            this.spawnParticle();
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.playerUUID != null) {
                this.ticksSinceMine = this.getPlayer() != null && !this.getPlayer().func_184587_cr() ? ++this.ticksSinceMine : 0;
            }
            if (this.packetReceived) {
                this.priorDurability = this.durability;
                this.durability = this.clientDurability;
                this.packetReceived = false;
            } else if (this.durability != 0) {
                this.priorDurability = this.durability;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.ticksSinceMine == 1) {
                this.priorDurability = this.durability;
                ServerTickHandler.addToList(this.field_174879_c, this.durability, this.field_145850_b);
            }
            if (this.ticksSinceMine >= 10) {
                this.priorDurability = this.durability++;
                ServerTickHandler.addToList(this.field_174879_c, this.durability, this.field_145850_b);
            }
            if (this.durability >= this.originalDurability) {
                this.resetBlock();
            }
            ++this.ticksSinceMine;
        }
    }

    public static boolean blockAllowed(List<ItemStack> drops, List<ItemStack> filters, boolean isWhiteList) {
        boolean blockAllowed = false;
        for (ItemStack dropStack : drops) {
            if (filters.size() == 0) {
                return true;
            }
            boolean contains = false;
            for (ItemStack filter : filters) {
                if (!dropStack.func_77969_a(filter)) continue;
                contains = true;
                break;
            }
            if (!(blockAllowed = isWhiteList && contains || !isWhiteList && !contains)) continue;
            break;
        }
        return blockAllowed;
    }

    public void setBlockAllowed() {
        Optional<Upgrade> upgrade;
        if (!UpgradeTools.containsActiveUpgradeFromList(this.gadgetUpgrades, Upgrade.VOID_JUNK)) {
            this.blockAllowed = true;
            return;
        }
        PlayerEntity player = this.field_145850_b.func_217371_b(this.playerUUID);
        if (player == null) {
            return;
        }
        boolean silk = false;
        int fortune = 0;
        ItemStack tempTool = new ItemStack((IItemProvider)ModItems.MININGGADGET.get());
        if (UpgradeTools.containsActiveUpgradeFromList(this.gadgetUpgrades, Upgrade.SILK)) {
            tempTool.func_77966_a(Enchantments.field_185306_r, 1);
            silk = true;
        }
        if (UpgradeTools.containsActiveUpgradeFromList(this.gadgetUpgrades, Upgrade.FORTUNE_1) && (upgrade = UpgradeTools.getUpgradeFromList(this.gadgetUpgrades, Upgrade.FORTUNE_1)).isPresent()) {
            fortune = upgrade.get().getTier();
            tempTool.func_77966_a(Enchantments.field_185308_t, fortune);
        }
        List drops = Block.func_220077_a((BlockState)this.renderBlock, (ServerWorld)((ServerWorld)this.field_145850_b), (BlockPos)this.field_174879_c, null, (Entity)player, (ItemStack)tempTool);
        this.blockAllowed = RenderBlockTileEntity.blockAllowed(drops, this.getGadgetFilters(), this.isGadgetIsWhitelist());
    }

    public boolean getBlockAllowed() {
        return this.blockAllowed;
    }
}

