/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.containers;

import com.direwolf20.mininggadgets.common.blocks.ModBlocks;
import com.direwolf20.mininggadgets.common.containers.ModContainers;
import com.direwolf20.mininggadgets.common.containers.ModificationTableCommands;
import com.direwolf20.mininggadgets.common.containers.WatchedSlot;
import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.common.items.UpgradeCard;
import com.direwolf20.mininggadgets.common.items.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.items.upgrade.UpgradeTools;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ModificationTableContainer
extends Container {
    private TileEntity tileEntity;
    private IItemHandler playerInventory;
    private List<Upgrade> upgradesCache = new ArrayList<Upgrade>();

    public ModificationTableContainer(int windowId, PlayerInventory playerInventory, PacketBuffer extraData) {
        super((ContainerType)ModContainers.MODIFICATIONTABLE_CONTAINER.get(), windowId);
        this.tileEntity = Minecraft.func_71410_x().field_71441_e.func_175625_s(extraData.func_179259_c());
        this.playerInventory = new InvWrapper((IInventory)playerInventory);
        this.setupContainerSlots();
        this.layoutPlayerInventorySlots(8, 84);
    }

    public ModificationTableContainer(int windowId, World world, BlockPos pos, PlayerInventory playerInventory) {
        super((ContainerType)ModContainers.MODIFICATIONTABLE_CONTAINER.get(), windowId);
        this.tileEntity = world.func_175625_s(pos);
        this.playerInventory = new InvWrapper((IInventory)playerInventory);
        this.setupContainerSlots();
        this.layoutPlayerInventorySlots(10, 70);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return ModificationTableContainer.func_216963_a((IWorldPosCallable)IWorldPosCallable.func_221488_a((World)this.getTE().func_145831_w(), (BlockPos)this.tileEntity.func_174877_v()), (PlayerEntity)playerIn, (Block)((Block)ModBlocks.MODIFICATION_TABLE.get()));
    }

    private void setupContainerSlots() {
        this.getTE().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> this.func_75146_a((Slot)new WatchedSlot((IItemHandler)h, 0, -16, 84, this::updateUpgradeCache)));
    }

    private void updateUpgradeCache(int index) {
        ItemStack stack = this.func_75139_a(index).func_75211_c();
        if (stack.func_190926_b() && !this.upgradesCache.isEmpty() || !(stack.func_77973_b() instanceof MiningGadget)) {
            this.upgradesCache.clear();
            return;
        }
        this.upgradesCache.clear();
        this.upgradesCache = UpgradeTools.getUpgrades(stack);
    }

    public List<Upgrade> getUpgradesCache() {
        return this.upgradesCache;
    }

    public TileEntity getTE() {
        return this.tileEntity;
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null || !slot.func_75216_d()) return itemstack;
        ItemStack stack = slot.func_75211_c();
        itemstack = stack.func_77946_l();
        if (index == 0) {
            if (!this.func_75135_a(stack, 1, this.func_75138_a().size(), true)) {
                return ItemStack.field_190927_a;
            }
            slot.func_75220_a(stack, itemstack);
        } else if (stack.func_77973_b() instanceof MiningGadget) {
            if (!this.func_75135_a(stack, 0, 1, false)) {
                return ItemStack.field_190927_a;
            }
        } else if (stack.func_77973_b() instanceof UpgradeCard) {
            if (!ModificationTableCommands.insertButton(this, stack)) return ItemStack.field_190927_a;
            int maxSize = Math.min(slot.func_75219_a(), stack.func_77976_d());
            int remove = maxSize - itemstack.func_190916_E();
            stack.func_190918_g(remove == 0 ? 1 : remove);
            this.updateUpgradeCache(0);
        } else if (index < 29 ? !this.func_75135_a(stack, 29, 37, false) : index < 38 && !this.func_75135_a(stack, 1, 29, false)) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        if (stack.func_190916_E() == itemstack.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        slot.func_190901_a(playerIn, stack);
        return itemstack;
    }
}

