/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies;

import com.gizmo.trophies.Registries;
import com.gizmo.trophies.TrophiesCommands;
import com.gizmo.trophies.TrophyConfig;
import com.gizmo.trophies.TrophyNetworkHandler;
import com.gizmo.trophies.item.TrophyItem;
import com.gizmo.trophies.trophy.Trophy;
import com.gizmo.trophies.trophy.behaviors.ClickWithItemBehavior;
import com.gizmo.trophies.trophy.behaviors.CustomBehaviorRegistry;
import com.gizmo.trophies.trophy.behaviors.ElderGuardianCurseBehavior;
import com.gizmo.trophies.trophy.behaviors.ExplosionBehavior;
import com.gizmo.trophies.trophy.behaviors.ItemDropBehavior;
import com.gizmo.trophies.trophy.behaviors.MobEffectBehavior;
import com.gizmo.trophies.trophy.behaviors.PlaceBlockBehavior;
import com.gizmo.trophies.trophy.behaviors.PlayerSetFireBehavior;
import com.gizmo.trophies.trophy.behaviors.PullFromLootTableBehavior;
import com.gizmo.trophies.trophy.behaviors.ShootArrowBehavior;
import com.gizmo.trophies.trophy.behaviors.ShootEnderPearlBehavior;
import com.gizmo.trophies.trophy.behaviors.ShootLlamaSpitBehavior;
import com.gizmo.trophies.trophy.behaviors.TotemOfUndyingEffectBehavior;
import com.mojang.brigadier.CommandDispatcher;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="obtrophies")
public class OpenBlocksTrophies {
    public static final String MODID = "obtrophies";
    public static final Logger LOGGER = LogManager.getLogger((String)"obtrophies");
    public static final RandomSource TROPHY_RANDOM = RandomSource.m_216327_();
    public static final CreativeModeTab TROPHY_TAB = new CreativeModeTab("obtrophies"){
        private List<String> keys = new ArrayList<String>();

        public ItemStack m_6976_() {
            if (this.keys.isEmpty() && !Trophy.getTrophies().isEmpty()) {
                this.keys = Trophy.getTrophies().keySet().stream().map(ResourceLocation::toString).collect(Collectors.toList());
            }
            ItemStack stack = new ItemStack((ItemLike)Registries.TROPHY_ITEM.get());
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("entity", this.keys.get(TROPHY_RANDOM.m_188503_(this.keys.size())));
            stack.m_41700_("BlockEntityTag", (Tag)tag);
            return stack;
        }

        public ItemStack m_40787_() {
            this.m_6976_();
            ItemStack stack = new ItemStack((ItemLike)Registries.TROPHY_ITEM.get());
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("entity", this.keys.get((int)(Minecraft.m_91087_().f_91073_.m_46467_() / 20L % (long)this.keys.size())));
            stack.m_41700_("BlockEntityTag", (Tag)tag);
            return stack;
        }
    };

    public OpenBlocksTrophies() {
        Pair specPair = new ForgeConfigSpec.Builder().configure(TrophyConfig.CommonConfig::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)specPair.getRight());
        TrophyConfig.COMMON_CONFIG = (TrophyConfig.CommonConfig)specPair.getLeft();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(this::maybeDropTrophy);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        MinecraftForge.EVENT_BUS.addListener(Trophy::reloadTrophies);
        MinecraftForge.EVENT_BUS.addListener(Trophy::syncTrophiesToClient);
        MinecraftForge.EVENT_BUS.addListener(this::grantBeeQueenViaDesireAdvancement);
        Registries.BLOCKS.register(bus);
        Registries.BLOCK_ENTITIES.register(bus);
        Registries.ITEMS.register(bus);
        Registries.LOOT_MODIFIERS.register(bus);
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MODID, path);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            CustomBehaviorRegistry.registerBehavior(new ClickWithItemBehavior());
            CustomBehaviorRegistry.registerBehavior(new MobEffectBehavior());
            CustomBehaviorRegistry.registerBehavior(new ItemDropBehavior());
            CustomBehaviorRegistry.registerBehavior(new PullFromLootTableBehavior());
            CustomBehaviorRegistry.registerBehavior(new ElderGuardianCurseBehavior());
            CustomBehaviorRegistry.registerBehavior(new ExplosionBehavior());
            CustomBehaviorRegistry.registerBehavior(new PlaceBlockBehavior());
            CustomBehaviorRegistry.registerBehavior(new PlayerSetFireBehavior());
            CustomBehaviorRegistry.registerBehavior(new ShootArrowBehavior());
            CustomBehaviorRegistry.registerBehavior(new ShootEnderPearlBehavior());
            CustomBehaviorRegistry.registerBehavior(new ShootLlamaSpitBehavior());
            CustomBehaviorRegistry.registerBehavior(new TotemOfUndyingEffectBehavior());
        });
        TrophyNetworkHandler.init();
    }

    public void registerCommands(RegisterCommandsEvent event) {
        TrophiesCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public void grantBeeQueenViaDesireAdvancement(AdvancementEvent.AdvancementEarnEvent event) {
        if (ModList.get().isLoaded("the_bumblezone")) {
            ItemStack trophy;
            if (event.getAdvancement().m_138327_().equals((Object)new ResourceLocation("the_bumblezone", "the_bumblezone/the_queens_desire/journeys_end"))) {
                trophy = TrophyItem.loadEntityToTrophy((EntityType)BzEntities.BEE_QUEEN.get());
                if (event.getEntity().m_36356_(trophy)) {
                    event.getEntity().m_36176_(trophy, false);
                }
            }
            if (event.getAdvancement().m_138327_().equals((Object)new ResourceLocation("the_bumblezone", "the_bumblezone/beehemoth/queen_beehemoth"))) {
                trophy = TrophyItem.loadEntityToTrophy((EntityType)BzEntities.BEEHEMOTH.get(), 1);
                if (event.getEntity().m_36356_(trophy)) {
                    event.getEntity().m_36176_(trophy, false);
                }
            }
        }
    }

    public void maybeDropTrophy(LivingDropsEvent event) {
        Trophy trophy;
        if (!(event.getSource().m_7639_() instanceof Player) && !((Boolean)TrophyConfig.COMMON_CONFIG.anySourceDropsTrophies.get()).booleanValue()) {
            return;
        }
        if (event.getSource().m_7639_() instanceof FakePlayer && !((Boolean)TrophyConfig.COMMON_CONFIG.fakePlayersDropTrophies.get()).booleanValue()) {
            return;
        }
        if (Trophy.getTrophies().containsKey(ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getEntity().m_6095_())) && (trophy = Trophy.getTrophies().get(ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getEntity().m_6095_()))) != null) {
            double trophyDropChance = (Double)TrophyConfig.COMMON_CONFIG.dropChanceOverride.get() >= 0.0 ? ((Double)TrophyConfig.COMMON_CONFIG.dropChanceOverride.get()).doubleValue() : trophy.getDropChance();
            double chance = ((double)event.getLootingLevel() + TROPHY_RANDOM.m_188500_() / 4.0) * trophyDropChance - TROPHY_RANDOM.m_188500_();
            if (chance > 0.0) {
                event.getDrops().add(new ItemEntity(event.getEntity().m_9236_(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), TrophyItem.loadEntityToTrophy(trophy.getType(), this.fetchVariantIfAny(event.getEntity(), trophy))));
            }
        }
    }

    private int fetchVariantIfAny(LivingEntity entity, Trophy trophy) {
        if (!trophy.getVariants(entity.m_9236_().m_5962_()).isEmpty()) {
            CompoundTag tag = new CompoundTag();
            entity.m_7380_(tag);
            for (int i = 0; i < trophy.getVariants(entity.m_9236_().m_5962_()).size(); ++i) {
                Map<String, String> variantKeys = trophy.getVariants(entity.m_9236_().m_5962_()).get(i);
                for (Map.Entry<String, String> entry : variantKeys.entrySet()) {
                    if (entity instanceof VillagerDataHolder) {
                        VillagerDataHolder villager = (VillagerDataHolder)entity;
                        if (!ForgeRegistries.VILLAGER_PROFESSIONS.getKey((Object)villager.m_7141_().m_35571_()).toString().equals(entry.getValue())) continue;
                        return i;
                    }
                    if (!tag.m_128441_(entry.getKey())) continue;
                    if (StringUtils.isNumeric((CharSequence)entry.getValue()) && tag.m_128451_(entry.getKey()) == Integer.parseInt(entry.getValue())) {
                        return i;
                    }
                    if ((entry.getValue().equals("false") || entry.getValue().equals("true")) && tag.m_128471_(entry.getKey()) == Boolean.parseBoolean(entry.getValue())) {
                        return i;
                    }
                    if (!tag.m_128461_(entry.getKey()).equals(entry.getValue()) && !tag.m_128461_(entry.getKey()).equals(new ResourceLocation(entry.getValue()).toString())) continue;
                    return i;
                }
            }
        }
        return 0;
    }
}

