/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies;

import com.gizmo.trophies.Registries;
import com.gizmo.trophies.block.TrophyBlock;
import com.gizmo.trophies.block.TrophyBlockEntity;
import com.gizmo.trophies.trophy.Trophy;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TrophiesCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"obtrophies").then(Commands.m_82127_((String)"count").executes(TrophiesCommands::count))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"placealltrophies").requires(cs -> cs.m_6761_(3))).executes(TrophiesCommands::placeAll)));
    }

    public static int count(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        if (Trophy.getTrophies().isEmpty()) {
            throw new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.obtrophies.empty_list").m_130940_(ChatFormatting.RED)).create();
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"command.obtrophies.count", (Object[])new Object[]{Trophy.getTrophies().size()}), false);
        return 1;
    }

    public static int placeAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        if (Trophy.getTrophies().isEmpty()) {
            throw new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.obtrophies.empty_list").m_130940_(ChatFormatting.RED)).create();
        }
        int amount = Trophy.getTrophies().size();
        int sideLength = (int)Math.ceil(Math.sqrt(amount));
        TreeMap sortedTrophies = new TreeMap(Comparator.naturalOrder());
        sortedTrophies.putAll(Trophy.getTrophies());
        for (int i = 0; i < sideLength; ++i) {
            int index;
            for (int j = 0; j < sideLength && (index = j + i * sideLength) <= amount - 1; ++j) {
                BlockPos pos = ((CommandSourceStack)context.getSource()).m_230896_().m_20183_().m_7918_(i, 0, j);
                ((CommandSourceStack)context.getSource()).m_81372_().m_46597_(pos, (BlockState)((Block)Registries.TROPHY.get()).m_49966_().m_61124_((Property)TrophyBlock.f_54117_, (Comparable)Direction.WEST));
                BlockEntity blockEntity = ((CommandSourceStack)context.getSource()).m_81372_().m_7702_(pos);
                if (!(blockEntity instanceof TrophyBlockEntity)) continue;
                TrophyBlockEntity trophyBE = (TrophyBlockEntity)blockEntity;
                trophyBE.setTrophy((Trophy)((Map.Entry)sortedTrophies.entrySet().stream().toList().get(index)).getValue());
            }
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"command.obtrophies.place", (Object[])new Object[]{amount}), false);
        return 1;
    }
}

