/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.compat;

import com.gizmo.trophies.client.TrophyRenderer;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;

public class EntityRenderer {
    private static final Set<EntityType<?>> IGNORED_ENTITIES = new HashSet();
    private static final Map<EntityType<?>, Entity> ENTITY_MAP = new HashMap();

    public static void render(PoseStack stack, @Nullable EntityType<?> type, int x, int y, Map<String, String> variant) {
        ClientLevel level;
        if (type != null && (level = Minecraft.m_91087_().f_91073_) != null && !IGNORED_ENTITIES.contains(type)) {
            Object entity = type == EntityType.f_20532_ ? Minecraft.m_91087_().f_91074_ : ENTITY_MAP.computeIfAbsent(type, arg_0 -> EntityRenderer.lambda$render$0((Level)level, arg_0));
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (!variant.isEmpty()) {
                    CompoundTag tag = new CompoundTag();
                    variant.forEach((s, s2) -> TrophyRenderer.convertStringToProperPrimitive(tag, s, s2));
                    livingEntity.m_7378_(tag);
                }
                int scale = 16;
                float height = entity.m_20206_();
                float width = entity.m_20205_();
                if (height <= 0.5f && width < 0.75f) {
                    scale = (int)(Math.max(height, width) * 48.0f);
                } else if (height < 1.0f && width < 0.75f) {
                    scale = (int)(Math.max(height, width) * 32.0f);
                } else if (height > 2.0f) {
                    scale = (int)(32.0f / Math.max(height, width));
                }
                try {
                    PoseStack modelView = RenderSystem.m_157191_();
                    modelView.m_85836_();
                    modelView.m_166854_(stack.m_85850_().m_85861_());
                    EntityRenderer.renderTheEntity(x, y, scale, livingEntity);
                    modelView.m_85849_();
                    RenderSystem.m_157182_();
                }
                catch (Exception e) {
                    TwilightForestMod.LOGGER.error("Error drawing entity " + ForgeRegistries.ENTITY_TYPES.getKey(type), (Throwable)e);
                    IGNORED_ENTITIES.add(type);
                    ENTITY_MAP.remove(type);
                }
            } else {
                IGNORED_ENTITIES.add(type);
                ENTITY_MAP.remove(type);
            }
        }
    }

    public static void renderTheEntity(int x, int y, int scale, LivingEntity entity) {
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_85837_((double)x, (double)y, 1050.0);
        EntityRenderer.applyAdditionalTransforms(entity.m_6095_(), posestack);
        posestack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.m_157182_();
        PoseStack posestack1 = new PoseStack();
        posestack1.m_85837_(0.0, 0.0, 1000.0);
        if (entity instanceof EnderDragon) {
            posestack1.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            posestack1.m_85845_(Vector3f.f_122223_.m_122240_(-30.0f));
        }
        posestack1.m_85841_((float)scale, (float)scale, (float)scale);
        Quaternion quaternion = Vector3f.f_122227_.m_122240_(180.0f);
        Quaternion quaternion1 = Vector3f.f_122223_.m_122240_(20.0f);
        quaternion.m_80148_(quaternion1);
        posestack1.m_85845_(quaternion);
        posestack1.m_85845_(Vector3f.f_122222_.m_122240_(35.0f));
        posestack1.m_85845_(Vector3f.f_122224_.m_122240_(145.0f));
        float f2 = entity.f_20883_;
        float f3 = entity.m_146908_();
        float f4 = entity.m_146909_();
        float f5 = entity.f_20886_;
        float f6 = entity.f_20885_;
        entity.f_20883_ = 0.0f;
        entity.m_146922_(0.0f);
        entity.m_146926_(0.0f);
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        Lighting.m_166384_();
        EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
        quaternion1.m_80157_();
        dispatcher.m_114412_(quaternion1);
        boolean hitboxes = dispatcher.m_114377_();
        dispatcher.m_114468_(false);
        dispatcher.m_114473_(false);
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.m_69890_(() -> dispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, posestack1, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0));
        multibuffersource$buffersource.m_109911_();
        dispatcher.m_114468_(true);
        dispatcher.m_114473_(hitboxes);
        entity.f_20883_ = f2;
        entity.m_146922_(f3);
        entity.m_146926_(f4);
        entity.f_20886_ = f5;
        entity.f_20885_ = f6;
        posestack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }

    private static void applyAdditionalTransforms(EntityType<?> entity, PoseStack stack) {
        if (entity == EntityType.f_20453_) {
            stack.m_85837_(0.0, -12.5, 0.0);
            stack.m_85841_(0.5f, 0.5f, 0.5f);
        }
        if (entity == EntityType.f_20565_) {
            stack.m_85837_(0.0, -4.0, 0.0);
        }
        if (entity == EntityType.f_20496_) {
            stack.m_85837_(0.0, 8.0, 0.0);
        }
        if (entity == EntityType.f_20480_ || entity == EntityType.f_147034_) {
            stack.m_85837_(0.0, -19.0, 0.0);
        }
        if (entity == EntityType.f_20563_) {
            stack.m_85841_(0.6f, 0.6f, 0.6f);
        }
    }

    private static /* synthetic */ Entity lambda$render$0(Level level, EntityType t) {
        return t.m_20615_(level);
    }
}

