/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.data;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.gizmo.trophies.trophy.Trophy;
import com.gizmo.trophies.trophy.TrophyReloadListener;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class TrophyProvider
implements DataProvider {
    protected final Map<ResourceLocation, Trophy> builder = Maps.newLinkedHashMap();
    private final String modid;
    private final DataGenerator.PathProvider entryPath;

    public TrophyProvider(DataGenerator generator, String modid) {
        this.modid = modid;
        this.entryPath = generator.m_236036_(DataGenerator.Target.DATA_PACK, "trophies");
    }

    public void m_213708_(CachedOutput output) {
        HashMap map = Maps.newHashMap();
        this.builder.clear();
        this.createTrophies();
        map.putAll(this.builder);
        map.forEach((resourceLocation, trophy) -> {
            Path path = this.entryPath.m_236048_(resourceLocation);
            try {
                DataProvider.m_236072_((CachedOutput)output, (JsonElement)TrophyReloadListener.serialize(trophy), (Path)path);
            }
            catch (IOException ioexception) {
                OpenBlocksTrophies.LOGGER.error("Couldn't save trophy entry {}", (Object)path, (Object)ioexception);
            }
        });
    }

    protected abstract void createTrophies();

    protected void makeTrophy(Trophy trophy) {
        this.builder.putIfAbsent(new ResourceLocation(this.modid, Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(trophy.getType())).m_135815_()), trophy);
    }

    public String m_6055_() {
        return this.modid + " Trophies";
    }
}

