/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.item;

import com.gizmo.trophies.Registries;
import com.gizmo.trophies.client.TrophyItemRenderer;
import com.gizmo.trophies.trophy.Trophy;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class TrophyItem
extends BlockItem {
    public static final String ENTITY_TAG = "entity";
    public static final String COOLDOWN_TAG = "cooldown";
    public static final String VARIANT_TAG = "VariantID";

    public TrophyItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @Nullable
    public static Trophy getTrophy(@Nonnull ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = BlockItem.m_186336_((ItemStack)stack)) != null && tag.m_128441_(ENTITY_TAG)) {
            String entityKey = tag.m_128461_(ENTITY_TAG);
            if (Trophy.getTrophies().containsKey(ResourceLocation.m_135820_((String)entityKey))) {
                return Trophy.getTrophies().get(ResourceLocation.m_135820_((String)entityKey));
            }
        }
        return null;
    }

    public static ItemStack loadEntityToTrophy(EntityType<?> type) {
        return TrophyItem.loadEntityToTrophy(type, 0);
    }

    public static ItemStack loadEntityToTrophy(EntityType<?> type, int variant) {
        ItemStack stack = new ItemStack((ItemLike)Registries.TROPHY_ITEM.get());
        CompoundTag tag = new CompoundTag();
        tag.m_128405_(VARIANT_TAG, variant);
        tag.m_128359_(ENTITY_TAG, Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(type)).toString());
        stack.m_41700_("BlockEntityTag", (Tag)tag);
        return stack;
    }

    public static int getTrophyVariant(@Nonnull ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = BlockItem.m_186336_((ItemStack)stack)) != null && tag.m_128441_(VARIANT_TAG)) {
            return tag.m_128451_(VARIANT_TAG);
        }
        return 0;
    }

    public Component m_7626_(ItemStack stack) {
        Trophy trophy = TrophyItem.getTrophy(stack);
        if (trophy != null) {
            return Component.m_237110_((String)"block.obtrophies.trophy.entity", (Object[])new Object[]{trophy.getType().m_20676_().getString()});
        }
        return super.m_7626_(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        Trophy trophy = TrophyItem.getTrophy(stack);
        if (trophy != null) {
            tooltip.add((Component)Component.m_237110_((String)"item.obtrophies.trophy.modid", (Object[])new Object[]{this.getModIdForTooltip(Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(trophy.getType())).m_135827_())}).m_130940_(ChatFormatting.GRAY));
            if (flag.m_7050_()) {
                int variant = TrophyItem.getTrophyVariant(stack);
                if (level != null && !trophy.getVariants(level.m_5962_()).isEmpty() && trophy.getVariants(level.m_5962_()).size() >= variant) {
                    Map<String, String> variantDefiners = trophy.getVariants(level.m_5962_()).get(variant);
                    variantDefiners.forEach((key, value) -> tooltip.add((Component)Component.m_237110_((String)"\"%s\": \"%s\"", (Object[])new Object[]{key, value}).m_130940_(ChatFormatting.GRAY)));
                }
            }
        }
    }

    private String getModIdForTooltip(String modId) {
        return ModList.get().getModContainerById(modId).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElseGet(() -> StringUtils.capitalize((String)modId));
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot slot, Entity entity) {
        return slot == EquipmentSlot.HEAD;
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> stacks) {
        if (this.m_220152_(tab) && !Trophy.getTrophies().isEmpty()) {
            TreeMap sortedTrophies = new TreeMap(Comparator.naturalOrder());
            sortedTrophies.putAll(Trophy.getTrophies());
            for (Map.Entry trophyEntry : sortedTrophies.entrySet()) {
                if (!((Trophy)trophyEntry.getValue()).getVariants(Minecraft.m_91087_().f_91073_.m_5962_()).isEmpty()) {
                    for (int i = 0; i < ((Trophy)trophyEntry.getValue()).getVariants(Minecraft.m_91087_().f_91073_.m_5962_()).size(); ++i) {
                        stacks.add((Object)TrophyItem.loadEntityToTrophy(((Trophy)trophyEntry.getValue()).getType(), i));
                    }
                    continue;
                }
                stacks.add((Object)TrophyItem.loadEntityToTrophy(((Trophy)trophyEntry.getValue()).getType()));
            }
        }
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new TrophyItemRenderer();
            }
        });
    }
}

