/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.trophy;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.gizmo.trophies.trophy.Trophy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class TrophyReloadListener
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(Trophy.class, (Object)new Trophy.Serializer()).create();
    private static final TreeMap<ResourceLocation, Trophy> validTrophies = new TreeMap();

    public TrophyReloadListener() {
        super(GSON, "trophies");
    }

    public static TreeMap<ResourceLocation, Trophy> getValidTrophies() {
        return validTrophies;
    }

    public static JsonElement serialize(Trophy trophy) {
        return GSON.toJsonTree((Object)trophy);
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller profiler) {
        validTrophies.clear();
        map.forEach((resourceLocation, jsonElement) -> {
            if (ModList.get().isLoaded(resourceLocation.m_135827_())) {
                try {
                    JsonObject object = GsonHelper.m_13918_((JsonElement)jsonElement, (String)"trophy");
                    Trophy trophy = Trophy.fromJson(object);
                    if (ForgeRegistries.ENTITY_TYPES.containsValue(trophy.getType())) {
                        validTrophies.put(ForgeRegistries.ENTITY_TYPES.getKey(trophy.getType()), trophy);
                    }
                }
                catch (Exception exception) {
                    OpenBlocksTrophies.LOGGER.error("Caught an error loading trophy config for {}! {}", resourceLocation, (Object)exception.getMessage());
                }
            }
        });
        OpenBlocksTrophies.LOGGER.info("Loaded {} Trophy configs.", (Object)validTrophies.size());
    }
}

