/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.trophy.behaviors;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.gizmo.trophies.block.TrophyBlockEntity;
import com.gizmo.trophies.trophy.behaviors.CustomBehavior;
import com.gizmo.trophies.trophy.behaviors.CustomBehaviorRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ClickWithItemBehavior
extends CustomBehavior {
    private final String clickedItemOrTag;
    private final boolean consumeStack;
    @Nullable
    private final CustomBehavior executeBehavior;
    private final int cooldown;
    @Nullable
    private final SoundEvent sound;

    public ClickWithItemBehavior() {
        this(Items.f_41852_, true, null, 0, null);
    }

    public ClickWithItemBehavior(Item clickedItem, boolean consumeStack, @Nullable CustomBehavior executeBehavior) {
        this(clickedItem, consumeStack, executeBehavior, 0, null);
    }

    public ClickWithItemBehavior(Item clickedItem, boolean consumeStack, @Nullable CustomBehavior executeBehavior, @Nullable SoundEvent sound) {
        this(clickedItem, consumeStack, executeBehavior, 0, sound);
    }

    public ClickWithItemBehavior(Item clickedItem, boolean consumeStack, @Nullable CustomBehavior executeBehavior, int cooldown, @Nullable SoundEvent sound) {
        this(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)clickedItem)).toString(), consumeStack, executeBehavior, cooldown, sound);
    }

    public ClickWithItemBehavior(TagKey<Item> clickedItem, boolean consumeStack, @Nullable CustomBehavior executeBehavior, int cooldown, @Nullable SoundEvent sound) {
        this("#" + Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).getTag(clickedItem).getKey().f_203868_(), consumeStack, executeBehavior, cooldown, sound);
    }

    private ClickWithItemBehavior(String clickedItem, boolean consumeStack, @Nullable CustomBehavior executeBehavior, int cooldown, @Nullable SoundEvent sound) {
        this.clickedItemOrTag = clickedItem;
        this.consumeStack = consumeStack;
        this.executeBehavior = executeBehavior;
        this.cooldown = cooldown;
        this.sound = sound;
    }

    @Override
    public ResourceLocation getType() {
        return OpenBlocksTrophies.location("right_click_item");
    }

    @Override
    public void serializeToJson(JsonObject object, JsonSerializationContext context) {
        object.add("item_to_use", context.serialize((Object)this.clickedItemOrTag));
        object.add("shrink_item_stack", context.serialize((Object)this.consumeStack));
        if (this.executeBehavior != null) {
            object.add("execute_behavior", context.serialize((Object)this.executeBehavior.serializeBehavior(context)));
        }
        if (this.cooldown != 0) {
            object.add("cooldown", context.serialize((Object)this.cooldown));
        }
        if (this.sound != null) {
            object.add("sound", context.serialize((Object)Objects.requireNonNull(ForgeRegistries.SOUND_EVENTS.getKey((Object)this.sound)).toString()));
        }
    }

    @Override
    public CustomBehavior fromJson(JsonObject object) {
        String jsonItem = GsonHelper.m_13906_((JsonObject)object, (String)"item_to_use");
        boolean consume = GsonHelper.m_13912_((JsonObject)object, (String)"shrink_item_stack");
        CustomBehavior behavior = null;
        if (object.has("execute_behavior")) {
            try {
                JsonObject bObject = GsonHelper.m_13918_((JsonElement)object.get("execute_behavior"), (String)"execute_behavior");
                CustomBehavior fetchedBehavior = CustomBehaviorRegistry.getBehavior(Objects.requireNonNull(ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)bObject, (String)"type"))));
                behavior = fetchedBehavior.fromJson(bObject);
            }
            catch (Exception e) {
                OpenBlocksTrophies.LOGGER.error("Could not fetch execute behavior, setting to null", (Throwable)e);
            }
        }
        int cooldown = GsonHelper.m_13824_((JsonObject)object, (String)"cooldown", (int)0);
        SoundEvent sound = null;
        if (object.has("sound")) {
            sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)object, (String)"sound")));
        }
        return new ClickWithItemBehavior(jsonItem, consume, behavior, cooldown, sound);
    }

    @Override
    public int execute(TrophyBlockEntity block, ServerPlayer player, ItemStack usedItem) {
        ArrayList<Object> items = new ArrayList<Object>();
        try {
            if (this.clickedItemOrTag.startsWith("#")) {
                items.addAll(Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).getTag(Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).createTagKey(Objects.requireNonNull(ResourceLocation.m_135820_((String)this.clickedItemOrTag.replace("#", ""))))).stream().toList());
            } else {
                items.add((Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)this.clickedItemOrTag)));
            }
        }
        catch (Exception e) {
            OpenBlocksTrophies.LOGGER.error("{} threw an error!", (Object)this.getClass().getName(), (Object)e);
        }
        if (!items.isEmpty() && items.contains(usedItem.m_41720_())) {
            if (this.executeBehavior != null) {
                this.executeBehavior.execute(block, player, usedItem);
            }
            if (this.consumeStack && !player.m_7500_()) {
                usedItem.m_41774_(1);
            }
            if (this.sound != null) {
                player.m_9236_().m_5594_(null, player.m_20183_(), this.sound, SoundSource.BLOCKS, 1.0f, (player.m_217043_().m_188501_() - player.m_217043_().m_188501_()) * 0.2f + 1.0f);
            }
            return this.cooldown;
        }
        return 0;
    }
}

