/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.trophy.behaviors;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.gizmo.trophies.block.TrophyBlockEntity;
import com.gizmo.trophies.trophy.behaviors.CustomBehavior;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;

public class ExplosionBehavior
extends CustomBehavior {
    private final float power;
    private final boolean destructive;

    public ExplosionBehavior() {
        this(0.0f, false);
    }

    public ExplosionBehavior(float power, boolean destructive) {
        this.power = power;
        this.destructive = destructive;
    }

    @Override
    public ResourceLocation getType() {
        return OpenBlocksTrophies.location("explosion");
    }

    @Override
    public void serializeToJson(JsonObject object, JsonSerializationContext context) {
        object.add("power", context.serialize((Object)Float.valueOf(this.power)));
        object.add("destructive", context.serialize((Object)this.destructive));
    }

    @Override
    public CustomBehavior fromJson(JsonObject object) {
        float power = GsonHelper.m_13915_((JsonObject)object, (String)"power");
        boolean destructive = GsonHelper.m_13912_((JsonObject)object, (String)"destructive");
        return new ExplosionBehavior(power, destructive);
    }

    @Override
    public int execute(TrophyBlockEntity block, ServerPlayer player, ItemStack usedItem) {
        BlockPos pos = block.m_58899_();
        player.m_9236_().m_46511_((Entity)player, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), this.power, this.destructive ? Explosion.BlockInteraction.BREAK : Explosion.BlockInteraction.NONE);
        return 0;
    }
}

