/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.trophy.behaviors;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.gizmo.trophies.block.TrophyBlockEntity;
import com.gizmo.trophies.trophy.behaviors.CustomBehavior;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemHandlerHelper;

public class PullFromLootTableBehavior
extends CustomBehavior {
    private final ResourceLocation lootTable;
    private final int tableRolls;
    private final int cooldown;

    public PullFromLootTableBehavior() {
        this(null, 0);
    }

    public PullFromLootTableBehavior(ResourceLocation lootTable, int cooldown) {
        this(lootTable, 1, cooldown);
    }

    public PullFromLootTableBehavior(ResourceLocation lootTable, int rolls, int cooldown) {
        this.lootTable = lootTable;
        this.tableRolls = rolls;
        this.cooldown = cooldown;
    }

    @Override
    public ResourceLocation getType() {
        return OpenBlocksTrophies.location("loot_table");
    }

    @Override
    public void serializeToJson(JsonObject object, JsonSerializationContext context) {
        object.add("loot_table", context.serialize((Object)this.lootTable.toString()));
        object.add("rolls", context.serialize((Object)this.tableRolls));
        object.add("cooldown", context.serialize((Object)this.cooldown));
    }

    @Override
    public CustomBehavior fromJson(JsonObject object) {
        ResourceLocation table = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)object, (String)"loot_table"));
        int rolls = GsonHelper.m_13824_((JsonObject)object, (String)"rolls", (int)1);
        int cooldown = GsonHelper.m_13824_((JsonObject)object, (String)"cooldown", (int)1000);
        return new PullFromLootTableBehavior(table, rolls, cooldown);
    }

    @Override
    public int execute(TrophyBlockEntity block, ServerPlayer player, ItemStack usedItem) {
        for (int i = 0; i < this.tableRolls; ++i) {
            LootContext.Builder builder = new LootContext.Builder(player.m_9236_()).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)block.m_58899_())).m_78972_(LootContextParams.f_81455_, (Object)player).m_78963_(player.m_36336_()).m_230911_(player.m_217043_());
            player.m_9236_().m_7654_().m_129898_().m_79217_(this.lootTable).m_230922_(builder.m_78975_(LootContextParamSets.f_81418_)).forEach(stack -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack.m_41777_()));
        }
        return this.cooldown;
    }
}

