/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.client;

import com.gizmo.trophies.client.TrophyExtraRendering;
import com.gizmo.trophies.client.TrophyRenderer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EntityCache {
    private static final Map<EntityType<?>, Entity> ENTITY_MAP = new HashMap();
    private static final Set<EntityType<?>> IGNORED_ENTITIES = new HashSet();

    @Nullable
    public static LivingEntity fetchEntity(EntityType<?> type, @Nullable Level level, Map<String, String> variant) {
        if (level != null && !IGNORED_ENTITIES.contains(type)) {
            Object entity = type == EntityType.f_20532_ ? Minecraft.m_91087_().f_91074_ : ENTITY_MAP.computeIfAbsent(type, t -> t.m_20615_(level));
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (TrophyExtraRendering.getRenderMap().containsKey(type)) {
                    TrophyExtraRendering.getRenderForEntity(type).createExtraRender((Entity)entity);
                }
                if (!variant.isEmpty()) {
                    if (entity instanceof VillagerDataHolder) {
                        VillagerDataHolder villager = (VillagerDataHolder)entity;
                        variant.forEach((s, s2) -> villager.m_34375_(new VillagerData(VillagerType.f_35821_, Objects.requireNonNull((VillagerProfession)Minecraft.m_91087_().f_91073_.m_9598_().m_175515_(Registries.f_256749_).m_7745_(ResourceLocation.m_135820_((String)s2))), 1)));
                    } else {
                        CompoundTag tag = new CompoundTag();
                        variant.forEach((s, s2) -> TrophyRenderer.convertStringToProperPrimitive(tag, s, s2));
                        living.m_7378_(tag);
                    }
                }
                return living;
            }
            IGNORED_ENTITIES.add(type);
            ENTITY_MAP.remove(type);
        }
        return null;
    }

    public static void addEntityToBlacklist(EntityType<?> type) {
        IGNORED_ENTITIES.add(type);
        ENTITY_MAP.remove(type);
    }
}

