/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.compat;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.gizmo.trophies.TrophyConfig;
import com.gizmo.trophies.compat.EntityRenderer;
import com.gizmo.trophies.compat.JEICompat;
import com.gizmo.trophies.compat.TrophyInfoWrapper;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class TrophyCategory
implements IRecipeCategory<TrophyInfoWrapper> {
    public static final int WIDTH = 116;
    public static final int HEIGHT = 54;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable fakePlayerIcon;
    private final IDrawable playerIcon;
    private final IDrawable arrowIcon;
    private final Component localizedName;

    public TrophyCategory(IGuiHelper helper) {
        ResourceLocation location = OpenBlocksTrophies.location("textures/gui/trophy_jei.png");
        this.background = helper.createDrawable(location, 0, 0, 116, 54);
        this.fakePlayerIcon = helper.createDrawable(location, 116, 0, 16, 16);
        this.playerIcon = helper.createDrawable(location, 116, 16, 16, 16);
        this.arrowIcon = helper.createDrawable(location, 116, 32, 23, 15);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)Items.f_42388_.m_7968_());
        this.localizedName = Component.m_237115_((String)"gui.obtrophies.trophy_jei");
    }

    public RecipeType<TrophyInfoWrapper> getRecipeType() {
        return JEICompat.TROPHY;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(TrophyInfoWrapper recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        EntityRenderer.render(graphics.m_280168_(), recipe.getTrophyEntity(), 25, 42, recipe.getTrophyVariant(Minecraft.m_91087_().f_91073_.m_9598_()));
        if (!((Boolean)TrophyConfig.COMMON_CONFIG.anySourceDropsTrophies.get()).booleanValue()) {
            if (((Boolean)TrophyConfig.COMMON_CONFIG.fakePlayersDropTrophies.get()).booleanValue()) {
                this.fakePlayerIcon.draw(graphics, 54, 19);
            } else {
                this.playerIcon.draw(graphics, 54, 19);
            }
        } else {
            this.arrowIcon.draw(graphics, 50, 19);
        }
        if (mouseX > 8.0 && mouseX < 43.0 && mouseY > 9.0 && mouseY < 44.0) {
            AbstractContainerScreen.m_280359_((GuiGraphics)graphics, (int)10, (int)11, (int)0);
            AbstractContainerScreen.m_280359_((GuiGraphics)graphics, (int)26, (int)11, (int)0);
            AbstractContainerScreen.m_280359_((GuiGraphics)graphics, (int)10, (int)27, (int)0);
            AbstractContainerScreen.m_280359_((GuiGraphics)graphics, (int)26, (int)27, (int)0);
        }
        graphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237110_((String)"gui.obtrophies.jei.drop_chance", (Object[])new Object[]{recipe.getTrophyDropPercentage()}), 46, 45, -8355712, false);
    }

    public List<Component> getTooltipStrings(TrophyInfoWrapper recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> components = new ArrayList<Component>();
        if (mouseX > 8.0 && mouseX < 43.0 && mouseY > 9.0 && mouseY < 44.0) {
            components.add(recipe.getTrophyEntity().m_20676_());
            if (Minecraft.m_91087_().f_91066_.f_92125_) {
                components.add((Component)Component.m_237113_((String)ForgeRegistries.ENTITY_TYPES.getKey(recipe.getTrophyEntity()).toString()).m_130940_(ChatFormatting.DARK_GRAY));
            }
            components.add((Component)Component.m_237113_((String)this.getModIdForTooltip(ForgeRegistries.ENTITY_TYPES.getKey(recipe.getTrophyEntity()).m_135827_())).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
        }
        if (mouseX > 51.0 && mouseX < 73.0 && mouseY > 19.0 && mouseY < 34.0 && !((Boolean)TrophyConfig.COMMON_CONFIG.anySourceDropsTrophies.get()).booleanValue()) {
            components.add((Component)Component.m_237115_((String)"gui.obtrophies.jei.player_drops").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            if (((Boolean)TrophyConfig.COMMON_CONFIG.fakePlayersDropTrophies.get()).booleanValue()) {
                components.add((Component)Component.m_237115_((String)"gui.obtrophies.jei.fake_player_drops").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            }
        }
        return components;
    }

    private String getModIdForTooltip(String modId) {
        return ModList.get().getModContainerById(modId).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElseGet(() -> StringUtils.capitalize((String)modId));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TrophyInfoWrapper recipe, IFocusGroup focuses) {
        SpawnEggItem egg = ForgeSpawnEggItem.fromEntityType(recipe.getTrophyEntity());
        if (egg != null) {
            builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStack(new ItemStack((ItemLike)egg));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 86, 19).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.getTrophyItem());
    }
}

