/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.data;

import com.gizmo.trophies.trophy.Trophy;
import com.gizmo.trophies.trophy.TrophyReloadListener;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class TrophyProvider
implements DataProvider {
    protected final Map<ResourceLocation, Trophy> builder = Maps.newLinkedHashMap();
    private final String modid;
    private final PackOutput.PathProvider entryPath;

    public TrophyProvider(PackOutput output, String modid) {
        this.modid = modid;
        this.entryPath = output.m_245269_(PackOutput.Target.DATA_PACK, "trophies");
    }

    public CompletableFuture<?> m_213708_(CachedOutput output) {
        HashMap map = Maps.newHashMap();
        this.builder.clear();
        this.createTrophies();
        map.putAll(this.builder);
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        map.forEach((resourceLocation, trophy) -> {
            Path path = this.entryPath.m_245731_(resourceLocation);
            futuresBuilder.add((Object)DataProvider.m_253162_((CachedOutput)output, (JsonElement)TrophyReloadListener.serialize(trophy), (Path)path));
        });
        return CompletableFuture.allOf((CompletableFuture[])futuresBuilder.build().toArray(CompletableFuture[]::new));
    }

    protected abstract void createTrophies();

    protected void makeTrophy(Trophy trophy) {
        this.builder.putIfAbsent(new ResourceLocation(this.modid, Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(trophy.getType())).m_135815_()), trophy);
    }

    public String m_6055_() {
        return this.modid + " Trophies";
    }
}

