/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.trophy;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.gizmo.trophies.SyncTrophyConfigsPacket;
import com.gizmo.trophies.TrophyNetworkHandler;
import com.gizmo.trophies.trophy.TrophyReloadListener;
import com.gizmo.trophies.trophy.behaviors.CustomBehavior;
import com.gizmo.trophies.trophy.behaviors.CustomBehaviorRegistry;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import it.unimi.dsi.fastutil.Pair;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class Trophy {
    private final EntityType<?> type;
    private final double dropChance;
    private final double verticalOffset;
    private final float scale;
    @Nullable
    private final CustomBehavior clickBehavior;
    private final List<Map<String, String>> variants;
    @Nullable
    private final Pair<String, ResourceKey<? extends Registry<?>>> registry;

    private Trophy(EntityType<?> type, double dropChance, double verticalOffset, float scale, @Nullable CustomBehavior behavior, List<Map<String, String>> variants, @Nullable Pair<String, ResourceKey<? extends Registry<?>>> registry) {
        this.type = type;
        this.dropChance = dropChance;
        this.verticalOffset = verticalOffset;
        this.scale = scale;
        this.clickBehavior = behavior;
        this.variants = variants;
        this.registry = registry;
    }

    public EntityType<?> getType() {
        return this.type;
    }

    public float getScale() {
        return this.scale;
    }

    public double getDropChance() {
        return this.dropChance;
    }

    public double getVerticalOffset() {
        return this.verticalOffset;
    }

    @Nullable
    public CustomBehavior getClickBehavior() {
        return this.clickBehavior;
    }

    public List<Map<String, String>> getVariants(@Nullable RegistryAccess access) {
        if (this.registry != null && access != null) {
            ArrayList<Map<String, String>> entries = new ArrayList<Map<String, String>>();
            Registry registry = access.m_175515_((ResourceKey)this.registry.right());
            for (Map.Entry entry : registry.m_6579_()) {
                try {
                    entries.add(Map.of((String)this.registry.left(), ((ResourceKey)entry.getKey()).m_135782_().toString()));
                }
                catch (ClassCastException e) {
                    OpenBlocksTrophies.LOGGER.error("Something went wrong when trying to fetch variants from a registry!");
                    e.printStackTrace();
                }
            }
            return entries;
        }
        return this.variants;
    }

    public void mergeVariantsFromOtherTrophy(Trophy trophy) {
        if (!trophy.variants.isEmpty()) {
            this.variants.addAll(trophy.variants);
        }
    }

    public static void reloadTrophies(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new TrophyReloadListener());
    }

    public static void syncTrophiesToClient(OnDatapackSyncEvent event) {
        if (FMLEnvironment.dist.isDedicatedServer()) {
            if (event.getPlayer() != null) {
                Trophy.splitMap(Trophy.getTrophies(), 50).forEach(splitMap -> {
                    TrophyNetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> ((OnDatapackSyncEvent)event).getPlayer()), (Object)new SyncTrophyConfigsPacket((Map<ResourceLocation, Trophy>)splitMap));
                    OpenBlocksTrophies.LOGGER.debug("sent a group of {} trophies to player {}", (Object)splitMap.size(), (Object)event.getPlayer().m_5446_());
                });
            } else {
                event.getPlayerList().m_11314_().forEach(player -> Trophy.splitMap(Trophy.getTrophies(), 50).forEach(splitMap -> {
                    TrophyNetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncTrophyConfigsPacket((Map<ResourceLocation, Trophy>)splitMap));
                    OpenBlocksTrophies.LOGGER.debug("sent a group of {} trophies to player {}", (Object)splitMap.size(), (Object)event.getPlayer().m_5446_());
                }));
            }
        }
    }

    private static <K, V> List<SortedMap<K, V>> splitMap(TreeMap<K, V> map, int size) {
        ArrayList<K> keys = new ArrayList<K>(map.keySet());
        ArrayList<SortedMap<K, V>> parts = new ArrayList<SortedMap<K, V>>();
        int listSize = map.size();
        for (int i = 0; i < listSize; i += size) {
            if (i + size < listSize) {
                parts.add(map.subMap(keys.get(i), keys.get(i + size)));
                continue;
            }
            parts.add(map.tailMap(keys.get(i)));
        }
        return parts;
    }

    public static TreeMap<ResourceLocation, Trophy> getTrophies() {
        return TrophyReloadListener.getValidTrophies();
    }

    public static Trophy fromJson(JsonObject object) {
        String entityType = GsonHelper.m_13906_((JsonObject)object, (String)"entity");
        if (ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.m_135820_((String)entityType)) == null) {
            throw new JsonParseException("Entity" + entityType + " defined in Trophy config does not exist!");
        }
        EntityType realEntity = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.m_135820_((String)entityType));
        double dropChance = GsonHelper.m_144742_((JsonObject)object, (String)"drop_chance", (double)0.001);
        double verticalOffset = GsonHelper.m_144742_((JsonObject)object, (String)"offset", (double)0.0);
        float scale = GsonHelper.m_13820_((JsonObject)object, (String)"scale", (float)1.0f);
        CustomBehavior behavior = null;
        if (object.has("behavior")) {
            try {
                JsonObject bObject = GsonHelper.m_13918_((JsonElement)object.get("behavior"), (String)"behavior");
                CustomBehavior fetchedBehavior = CustomBehaviorRegistry.getBehavior(Objects.requireNonNull(ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)bObject, (String)"type"))));
                behavior = fetchedBehavior.fromJson(bObject);
            }
            catch (Exception e) {
                OpenBlocksTrophies.LOGGER.error("Could not fetch custom behavior for trophy {}, setting to null", (Object)entityType, (Object)e);
            }
        }
        Pair registry = null;
        ArrayList<Map<String, String>> variants = new ArrayList<Map<String, String>>();
        if (object.has("variants")) {
            JsonArray array = GsonHelper.m_13933_((JsonObject)object, (String)"variants");
            array.forEach(jsonElement -> {
                HashMap variant = new HashMap();
                jsonElement.getAsJsonObject().entrySet().forEach(entry -> variant.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString()));
                variants.add(variant);
            });
        } else if (object.has("variant_registry")) {
            JsonObject vObject = GsonHelper.m_13918_((JsonElement)object.get("variant_registry"), (String)"variant_registry");
            registry = Pair.of((Object)GsonHelper.m_13906_((JsonObject)vObject, (String)"key"), (Object)ResourceKey.m_135788_((ResourceLocation)Objects.requireNonNull(ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)vObject, (String)"registry")))));
        }
        return new Trophy(Objects.requireNonNull(realEntity), dropChance, verticalOffset, scale, behavior, variants, registry);
    }

    public static Trophy fromNetwork(FriendlyByteBuf buf) {
        return new Trophy((EntityType)buf.readRegistryId(), buf.readDouble(), buf.readDouble(), buf.readFloat(), null, buf.m_236845_(buf1 -> buf1.m_236847_(FriendlyByteBuf::m_130277_, FriendlyByteBuf::m_130277_)), Trophy.handleRegistryPair(buf.m_130277_(), buf.m_130277_()));
    }

    @Nullable
    private static Pair<String, ResourceKey<? extends Registry<?>>> handleRegistryPair(String key, String registry) {
        return key.isEmpty() || registry.isEmpty() ? null : Pair.of((Object)key, (Object)ResourceKey.m_135788_((ResourceLocation)Objects.requireNonNull(ResourceLocation.m_135820_((String)registry))));
    }

    public void toNetwork(FriendlyByteBuf buf) {
        buf.writeRegistryId(ForgeRegistries.ENTITY_TYPES, this.type);
        buf.writeDouble(this.dropChance);
        buf.writeDouble(this.verticalOffset);
        buf.writeFloat(this.scale);
        buf.m_236828_(this.variants, (buf1, stringStringMap) -> buf1.m_236831_(stringStringMap, FriendlyByteBuf::m_130070_, FriendlyByteBuf::m_130070_));
        buf.m_130070_(this.registry != null ? (String)this.registry.left() : "");
        buf.m_130070_(this.registry != null ? ((ResourceKey)this.registry.right()).m_135782_().toString() : "");
    }

    public static class Builder {
        private final EntityType<?> type;
        private double dropChance = 0.001;
        private double verticalOffset = 0.0;
        private float scale = 1.0f;
        @Nullable
        private CustomBehavior clickBehavior = null;
        private final List<Map<String, String>> variants = new ArrayList<Map<String, String>>();
        @Nullable
        private Pair<String, ResourceKey<? extends Registry<?>>> registry = null;

        public Builder(EntityType<?> type) {
            this.type = type;
        }

        public Builder setDropChance(double chance) {
            this.dropChance = chance;
            return this;
        }

        public Builder setVerticalOffset(double offset) {
            this.verticalOffset = offset;
            return this;
        }

        public Builder setScale(float scale) {
            this.scale = scale;
            return this;
        }

        public Builder setRightClickBehavior(CustomBehavior behavior) {
            this.clickBehavior = behavior;
            return this;
        }

        public Builder addVariant(String variantId, String value) {
            this.variants.add(Map.of(variantId, value));
            return this;
        }

        public Builder addVariant(Map<String, String> variant) {
            this.variants.add(variant);
            return this;
        }

        public Builder addRegistry(String identifier, ResourceKey<? extends Registry<?>> registry) {
            this.registry = Pair.of((Object)identifier, registry);
            return this;
        }

        public Trophy build() {
            return new Trophy(this.type, this.dropChance, this.verticalOffset, this.scale, this.clickBehavior, this.variants, this.registry);
        }
    }

    public static class Serializer
    implements JsonSerializer<Trophy>,
    JsonDeserializer<Trophy> {
        public Trophy deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = GsonHelper.m_13918_((JsonElement)json, (String)"trophy");
            return Trophy.fromJson(object);
        }

        public JsonElement serialize(Trophy trophy, Type type, JsonSerializationContext context) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.add("entity", context.serialize((Object)Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(trophy.type)).toString()));
            jsonobject.add("drop_chance", context.serialize((Object)trophy.dropChance));
            jsonobject.add("offset", context.serialize((Object)trophy.verticalOffset));
            jsonobject.add("scale", context.serialize((Object)Float.valueOf(trophy.scale)));
            if (trophy.clickBehavior != null) {
                jsonobject.add("behavior", (JsonElement)trophy.clickBehavior.serializeBehavior(context));
            }
            if (!trophy.variants.isEmpty()) {
                JsonArray array = new JsonArray();
                trophy.variants.forEach(map -> {
                    List<Pair> variants = map.entrySet().stream().map(e -> Pair.of((Object)((String)e.getKey()), (Object)((String)e.getValue()))).sorted(Comparator.comparing(Pair::left)).toList();
                    JsonObject entryObject = new JsonObject();
                    variants.forEach(entry -> entryObject.add((String)entry.left(), context.serialize(entry.right())));
                    array.add((JsonElement)entryObject);
                });
                jsonobject.add("variants", (JsonElement)array);
            } else if (trophy.registry != null) {
                JsonObject object = new JsonObject();
                object.add("key", context.serialize(trophy.registry.left()));
                object.add("registry", context.serialize((Object)((ResourceKey)trophy.registry.right()).m_135782_().toString()));
                jsonobject.add("variant_registry", (JsonElement)object);
            }
            return jsonobject;
        }
    }
}

