/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies;

import com.gizmo.trophies.TrophiesCommands;
import com.gizmo.trophies.TrophyConfig;
import com.gizmo.trophies.TrophyNetworkHandler;
import com.gizmo.trophies.TrophyRegistries;
import com.gizmo.trophies.behavior.CustomTrophyBehaviors;
import com.gizmo.trophies.item.TrophyItem;
import com.gizmo.trophies.trophy.Trophy;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="obtrophies")
public class OpenBlocksTrophies {
    public static final String MODID = "obtrophies";
    public static final Logger LOGGER = LogManager.getLogger((String)"obtrophies");
    public static final RandomSource TROPHY_RANDOM = RandomSource.m_216327_();

    public OpenBlocksTrophies() {
        Pair specPair = new ForgeConfigSpec.Builder().configure(TrophyConfig.CommonConfig::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)specPair.getRight());
        TrophyConfig.COMMON_CONFIG = (TrophyConfig.CommonConfig)specPair.getLeft();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(this::maybeDropTrophy);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        MinecraftForge.EVENT_BUS.addListener(Trophy::reloadTrophies);
        MinecraftForge.EVENT_BUS.addListener(Trophy::syncTrophiesToClient);
        MinecraftForge.EVENT_BUS.addListener(this::grantBeeQueenViaDesireAdvancement);
        TrophyRegistries.BLOCKS.register(bus);
        TrophyRegistries.BLOCK_ENTITIES.register(bus);
        TrophyRegistries.ITEMS.register(bus);
        TrophyRegistries.LOOT_MODIFIERS.register(bus);
        TrophyRegistries.TABS.register(bus);
        CustomTrophyBehaviors.CUSTOM_BEHAVIORS.register(bus);
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MODID, path);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        TrophyNetworkHandler.init();
    }

    public void registerCommands(RegisterCommandsEvent event) {
        TrophiesCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public void grantBeeQueenViaDesireAdvancement(AdvancementEvent.AdvancementEarnEvent event) {
        if (ModList.get().isLoaded("the_bumblezone")) {
            ItemStack trophy;
            if (event.getAdvancement().m_138327_().equals((Object)new ResourceLocation("the_bumblezone", "the_bumblezone/the_queens_desire/journeys_end"))) {
                trophy = TrophyItem.loadEntityToTrophy(Objects.requireNonNull((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation("the_bumblezone", "bee_queen"))), 0, false);
                if (event.getEntity().m_36356_(trophy)) {
                    event.getEntity().m_36176_(trophy, false);
                }
            }
            if (event.getAdvancement().m_138327_().equals((Object)new ResourceLocation("the_bumblezone", "the_bumblezone/beehemoth/queen_beehemoth"))) {
                trophy = TrophyItem.loadEntityToTrophy(Objects.requireNonNull((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation("the_bumblezone", "beehemoth"))), 1, false);
                if (event.getEntity().m_36356_(trophy)) {
                    event.getEntity().m_36176_(trophy, false);
                }
            }
        }
    }

    public void maybeDropTrophy(LivingDropsEvent event) {
        Trophy trophy;
        if (!(event.getSource().m_7639_() instanceof Player) && !((Boolean)TrophyConfig.COMMON_CONFIG.anySourceDropsTrophies.get()).booleanValue()) {
            return;
        }
        if (event.getSource().m_7639_() instanceof FakePlayer && !((Boolean)TrophyConfig.COMMON_CONFIG.fakePlayersDropTrophies.get()).booleanValue()) {
            return;
        }
        if (Trophy.getTrophies().containsKey(ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getEntity().m_6095_())) && (trophy = Trophy.getTrophies().get(ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getEntity().m_6095_()))) != null) {
            double trophyDropChance = (Double)TrophyConfig.COMMON_CONFIG.dropChanceOverride.get() >= 0.0 ? ((Double)TrophyConfig.COMMON_CONFIG.dropChanceOverride.get()).doubleValue() : trophy.dropChance();
            double chance = ((double)event.getLootingLevel() + TROPHY_RANDOM.m_188500_() / 4.0) * trophyDropChance - TROPHY_RANDOM.m_188500_();
            if (chance > 0.0) {
                event.getDrops().add(new ItemEntity(event.getEntity().m_9236_(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), TrophyItem.loadEntityToTrophy(trophy.type(), this.fetchVariantIfAny(event.getEntity(), trophy), false)));
            }
        }
    }

    private int fetchVariantIfAny(LivingEntity entity, Trophy trophy) {
        if (!trophy.getVariants(entity.m_9236_().m_9598_()).isEmpty()) {
            CompoundTag tag = new CompoundTag();
            entity.m_7380_(tag);
            for (int i = 0; i < trophy.getVariants(entity.m_9236_().m_9598_()).size(); ++i) {
                CompoundTag variantKeys = trophy.getVariants(entity.m_9236_().m_9598_()).get(i);
                for (String s : variantKeys.m_128431_()) {
                    if (entity instanceof VillagerDataHolder) {
                        VillagerDataHolder villager = (VillagerDataHolder)entity;
                        if (!ForgeRegistries.VILLAGER_PROFESSIONS.getKey((Object)villager.m_7141_().m_35571_()).toString().equals(variantKeys.m_128461_(s))) continue;
                        return i;
                    }
                    Tag tagVer = tag.m_128423_(s);
                    Tag variantVer = variantKeys.m_128423_(s);
                    if (variantVer instanceof NumericTag) {
                        NumericTag number;
                        NumericTag num = (NumericTag)variantVer;
                        if (!(tagVer instanceof NumericTag) || (number = (NumericTag)tagVer).m_7046_() != num.m_7046_()) continue;
                        return i;
                    }
                    if (!Objects.equals(tagVer, variantVer)) continue;
                    return i;
                }
            }
        }
        return 0;
    }
}

