/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies;

import com.gizmo.trophies.TrophyRegistries;
import com.gizmo.trophies.block.TrophyBlock;
import com.gizmo.trophies.block.TrophyBlockEntity;
import com.gizmo.trophies.trophy.Trophy;
import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public class TrophiesCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"obtrophies").then(Commands.m_82129_((String)"dumpRegistry", (ArgumentType)StringArgumentType.string()).executes(context -> TrophiesCommands.getRegistryKeys((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"dumpRegistry"))))).then(Commands.m_82127_((String)"count").executes(TrophiesCommands::count))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"placetrophies").requires(cs -> cs.m_6761_(3))).executes(context -> TrophiesCommands.placeAll((CommandContext<CommandSourceStack>)context, false, "all"))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"variants", (ArgumentType)BoolArgumentType.bool()).executes(context -> TrophiesCommands.placeAll((CommandContext<CommandSourceStack>)context, BoolArgumentType.getBool((CommandContext)context, (String)"variants"), "all"))).then(Commands.m_82129_((String)"modid", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_(TrophiesCommands.getLoadedModIds(), (SuggestionsBuilder)builder)).executes(context -> TrophiesCommands.placeAll((CommandContext<CommandSourceStack>)context, BoolArgumentType.getBool((CommandContext)context, (String)"variants"), StringArgumentType.getString((CommandContext)context, (String)"modid")))))));
    }

    public static List<String> getLoadedModIds() {
        ArrayList<String> modids = new ArrayList<String>();
        for (IModInfo info : ModList.get().getMods()) {
            modids.add(info.getModId());
        }
        Collections.sort(modids);
        return modids;
    }

    public static int getRegistryKeys(CommandContext<CommandSourceStack> context, String registryName) throws CommandSyntaxException {
        try {
            ResourceKey key = ResourceKey.m_135788_((ResourceLocation)ResourceLocation.m_135820_((String)registryName));
            ((CommandSourceStack)context.getSource()).m_5894_().m_175515_(key).m_6579_().forEach(entry -> ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)(((ResourceKey)entry.getKey()).m_135782_() + ": " + entry.getValue().toString()))));
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("Registry Size: " + ((CommandSourceStack)context.getSource()).m_5894_().m_175515_(key).m_6579_().size())));
        }
        catch (Exception e) {
            throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)e.getMessage())).create();
        }
        return 1;
    }

    public static int count(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        if (Trophy.getTrophies().isEmpty()) {
            throw new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.obtrophies.empty_list").m_130940_(ChatFormatting.RED)).create();
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.obtrophies.count", (Object[])new Object[]{Trophy.getTrophies().size()}), false);
        return 1;
    }

    public static int placeAll(CommandContext<CommandSourceStack> context, boolean placeVariants, String modid) throws CommandSyntaxException {
        if (Trophy.getTrophies().isEmpty()) {
            throw new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.obtrophies.empty_list").m_130940_(ChatFormatting.RED)).create();
        }
        TreeMap sortedTrophies = new TreeMap(Comparator.naturalOrder());
        if (!modid.equals("all")) {
            sortedTrophies.putAll(Maps.filterKeys(Trophy.getTrophies(), input -> input.m_135827_().equals(modid)));
        } else {
            sortedTrophies.putAll(Trophy.getTrophies());
        }
        int amount = sortedTrophies.size();
        int sideLength = (int)Math.ceil(Math.sqrt(amount));
        for (int i = 0; i < sideLength; ++i) {
            int index;
            for (int j = 0; j < sideLength && (index = j + i * sideLength) <= amount - 1; ++j) {
                Trophy trophy = (Trophy)((Map.Entry)sortedTrophies.entrySet().stream().toList().get(index)).getValue();
                if (placeVariants && !trophy.getVariants(((CommandSourceStack)context.getSource()).m_81372_().m_9598_()).isEmpty()) {
                    for (int v = 0; v < trophy.getVariants(((CommandSourceStack)context.getSource()).m_81372_().m_9598_()).size(); ++v) {
                        BlockPos pos = BlockPos.m_274446_((Position)((CommandSourceStack)context.getSource()).m_81371_()).m_7918_(i, v, j);
                        TrophiesCommands.setupTrophy((Level)((CommandSourceStack)context.getSource()).m_81372_(), pos, trophy, v);
                    }
                    continue;
                }
                BlockPos pos = BlockPos.m_274446_((Position)((CommandSourceStack)context.getSource()).m_81371_()).m_7918_(i, 0, j);
                TrophiesCommands.setupTrophy((Level)((CommandSourceStack)context.getSource()).m_81372_(), pos, trophy, -1);
            }
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.obtrophies.place", (Object[])new Object[]{amount}), false);
        return 1;
    }

    private static void setupTrophy(Level level, BlockPos pos, Trophy trophy, int variant) {
        level.m_46597_(pos, (BlockState)((Block)TrophyRegistries.TROPHY.get()).m_49966_().m_61124_((Property)TrophyBlock.f_54117_, (Comparable)Direction.WEST));
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TrophyBlockEntity) {
            TrophyBlockEntity trophyBE = (TrophyBlockEntity)blockEntity;
            trophyBE.setTrophy(trophy);
            if (variant != -1) {
                trophyBE.setVariant(variant);
            }
        }
    }
}

