/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.behavior;

import com.gizmo.trophies.behavior.CustomBehavior;
import com.gizmo.trophies.behavior.CustomBehaviorType;
import com.gizmo.trophies.behavior.CustomTrophyBehaviors;
import com.gizmo.trophies.block.TrophyBlockEntity;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public record ShootArrowBehavior(int amount, Optional<MobEffect> effect) implements CustomBehavior
{
    public static final Codec<ShootArrowBehavior> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("amount", (Object)1).forGetter(ShootArrowBehavior::amount), (App)ForgeRegistries.MOB_EFFECTS.getCodec().optionalFieldOf("effect").orElse(null).forGetter(ShootArrowBehavior::effect)).apply((Applicative)instance, ShootArrowBehavior::new));

    public ShootArrowBehavior(int amount, @Nullable MobEffect effect) {
        this(amount, Optional.ofNullable(effect));
    }

    public ShootArrowBehavior() {
        this(1, Optional.empty());
    }

    @Override
    public CustomBehaviorType getType() {
        return (CustomBehaviorType)CustomTrophyBehaviors.ARROW.get();
    }

    @Override
    public int execute(TrophyBlockEntity block, ServerPlayer player, ItemStack usedItem) {
        BlockPos pos = block.m_58899_();
        Level level = player.m_9236_();
        for (int i = 0; i < this.amount(); ++i) {
            Arrow arrow = new Arrow(level, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 1.0f), (double)pos.m_123343_() + 0.5);
            arrow.m_36781_(0.1);
            arrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            if (this.effect().isPresent()) {
                arrow.m_36870_(new MobEffectInstance(this.effect().get()));
            }
            arrow.m_6686_((double)(level.m_213780_().m_188503_(10) - 5), 40.0, (double)(level.m_213780_().m_188503_(10) - 5), 1.0f, 6.0f);
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_11687_, SoundSource.NEUTRAL, 1.0f, 1.0f / (level.m_213780_().m_188501_() * 0.4f + 1.2f) + 0.5f);
            level.m_7967_((Entity)arrow);
        }
        return 10 * this.amount();
    }
}

