/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.client;

import com.gizmo.trophies.block.TrophyBlock;
import com.gizmo.trophies.block.TrophyBlockEntity;
import com.gizmo.trophies.client.EntityCache;
import com.gizmo.trophies.trophy.Trophy;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TrophyRenderer
implements BlockEntityRenderer<TrophyBlockEntity> {
    private static final List<ResourceLocation> keys = new ArrayList<ResourceLocation>();

    public TrophyRenderer(BlockEntityRendererProvider.Context unused) {
    }

    public static void renderEntity(@Nullable TrophyBlockEntity be, int variant, String name, Level level, BlockPos pos, Trophy trophy, PoseStack stack, MultiBufferSource source, int light, boolean cycling) {
        stack.m_85836_();
        if (keys.isEmpty() && !Trophy.getTrophies().isEmpty()) {
            keys.addAll(Trophy.getTrophies().keySet().stream().toList());
            Collections.shuffle(keys);
        }
        if (cycling && !keys.isEmpty()) {
            trophy = Trophy.getTrophies().get(keys.get((int)(((float)level.m_46467_() + Minecraft.m_91087_().getPartialTick()) / 20.0f % (float)keys.size())));
        }
        List<CompoundTag> variants = trophy.getVariants(level.m_9598_());
        LivingEntity entity = EntityCache.fetchEntity(trophy.type(), level, variant < variants.size() ? variants.get(variant) : null, trophy.defaultData());
        if (entity != null) {
            EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
            boolean hitboxes = dispatcher.m_114377_();
            dispatcher.m_114468_(false);
            dispatcher.m_114473_(false);
            entity.m_6593_((Component)(!name.isEmpty() ? Component.m_237113_((String)name) : null));
            entity.m_20340_(false);
            entity.f_19797_ = entity instanceof Sheep && entity.m_8077_() ? (int)level.m_6106_().m_6793_() : 0;
            entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.25 + trophy.verticalOffset(), (double)pos.m_123343_() + 0.5);
            stack.m_85837_(0.5, 0.25 + trophy.verticalOffset(), 0.5);
            if (be != null) {
                if (LocalDate.of(LocalDate.now().getYear(), 4, 1).equals(LocalDate.now())) {
                    Player player = level.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 64.0, false);
                    if (player != null) {
                        Vec3 vec3 = new Vec3(player.m_20185_(), player.m_20188_(), player.m_20189_());
                        Vec3 vec31 = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_() + (double)entity.m_20192_() / 1.5, (double)pos.m_123343_());
                        Vec3 vec32 = vec3.m_82546_(vec31);
                        vec32 = vec32.m_82541_();
                        float f5 = (float)Math.acos(vec32.m_7098_());
                        float f6 = (float)Math.atan2(vec32.m_7094_(), vec32.m_7096_());
                        stack.m_252781_(Axis.f_252436_.m_252977_((1.5707964f - f6) * 57.295776f));
                        stack.m_252781_(Axis.f_252529_.m_252977_(f5 * 57.295776f - 90.0f));
                    }
                } else {
                    stack.m_252781_(Axis.f_252436_.m_252977_(TrophyRenderer.getCorrectRotation(((Direction)be.m_58900_().m_61143_((Property)TrophyBlock.f_54117_)).m_122424_())));
                }
            }
            if (entity instanceof EnderDragon) {
                stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            }
            stack.m_85841_(0.4f, 0.4f, 0.4f);
            stack.m_85841_(trophy.scale(), trophy.scale(), trophy.scale());
            RenderSystem.runAsFancy(() -> TrophyRenderer.lambda$renderEntity$0(dispatcher, (Entity)entity, stack, source, light));
            dispatcher.m_114468_(true);
            dispatcher.m_114473_(hitboxes);
        }
        stack.m_85849_();
    }

    private static float getCorrectRotation(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN, Direction.UP, Direction.NORTH -> 0.0f;
            case Direction.SOUTH -> 180.0f;
            case Direction.EAST -> 270.0f;
            case Direction.WEST -> 90.0f;
        };
    }

    public void render(TrophyBlockEntity blockEntity, float partialTicks, PoseStack stack, MultiBufferSource source, int light, int overlay) {
        if (blockEntity.getTrophy() != null) {
            stack.m_85836_();
            if (!((Boolean)blockEntity.m_58900_().m_61143_((Property)TrophyBlock.PEDESTAL)).booleanValue()) {
                stack.m_85837_(0.0, -0.25, 0.0);
            }
            TrophyRenderer.renderEntity(blockEntity, blockEntity.getVariant(), blockEntity.getTrophyName(), blockEntity.m_58904_(), blockEntity.m_58899_(), blockEntity.getTrophy(), stack, source, light, blockEntity.isCycling());
            stack.m_85849_();
        }
    }

    private static /* synthetic */ void lambda$renderEntity$0(EntityRenderDispatcher dispatcher, Entity entity, PoseStack stack, MultiBufferSource source, int light) {
        dispatcher.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, stack, source, light);
    }
}

