/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.item;

import com.gizmo.trophies.TrophyRegistries;
import com.gizmo.trophies.client.TrophyItemRenderer;
import com.gizmo.trophies.trophy.Trophy;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class TrophyItem
extends BlockItem {
    public static final String ENTITY_TAG = "entity";
    public static final String COOLDOWN_TAG = "cooldown";
    public static final String CYCLING_TAG = "SpecialCycleVariant";
    public static final String VARIANT_TAG = "VariantID";

    public TrophyItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @Nullable
    public static Trophy getTrophy(@Nonnull ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = BlockItem.m_186336_((ItemStack)stack)) != null && tag.m_128441_(ENTITY_TAG)) {
            String entityKey = tag.m_128461_(ENTITY_TAG);
            if (Trophy.getTrophies().containsKey(ResourceLocation.m_135820_((String)entityKey))) {
                return Trophy.getTrophies().get(ResourceLocation.m_135820_((String)entityKey));
            }
        }
        return null;
    }

    public static boolean hasCycleOnTrophy(@Nonnull ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = BlockItem.m_186336_((ItemStack)stack)) != null && tag.m_128441_(CYCLING_TAG)) {
            return tag.m_128471_(CYCLING_TAG);
        }
        return false;
    }

    public static ItemStack loadEntityToTrophy(EntityType<?> type, int variant, boolean cycling) {
        ItemStack stack = new ItemStack((ItemLike)TrophyRegistries.TROPHY_ITEM.get());
        stack.m_41751_(TrophyItem.createTrophyTag(type, variant, cycling));
        return stack;
    }

    public static CompoundTag createTrophyTag(EntityType<?> type, int variant, boolean cycling) {
        CompoundTag tag = new CompoundTag();
        CompoundTag beTag = new CompoundTag();
        beTag.m_128359_(ENTITY_TAG, Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(type)).toString());
        if (variant > -1) {
            beTag.m_128405_(VARIANT_TAG, variant);
        }
        if (cycling) {
            beTag.m_128379_(CYCLING_TAG, true);
        }
        tag.m_128365_("BlockEntityTag", (Tag)beTag);
        return tag;
    }

    public static int getTrophyVariant(@Nonnull ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = BlockItem.m_186336_((ItemStack)stack)) != null && tag.m_128441_(VARIANT_TAG)) {
            return tag.m_128451_(VARIANT_TAG);
        }
        return 0;
    }

    public Component m_7626_(ItemStack stack) {
        Trophy trophy = TrophyItem.getTrophy(stack);
        if (trophy != null && !TrophyItem.hasCycleOnTrophy(stack)) {
            return Component.m_237110_((String)"block.obtrophies.trophy.entity", (Object[])new Object[]{trophy.type().m_20676_().getString()});
        }
        return super.m_7626_(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        Trophy trophy = TrophyItem.getTrophy(stack);
        if (trophy != null && !TrophyItem.hasCycleOnTrophy(stack)) {
            tooltip.add((Component)Component.m_237110_((String)"item.obtrophies.trophy.modid", (Object[])new Object[]{this.getModIdForTooltip(Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(trophy.type())).m_135827_())}).m_130940_(ChatFormatting.GRAY));
            if (flag.m_7050_()) {
                int variant = TrophyItem.getTrophyVariant(stack);
                if (level != null && !trophy.getVariants(level.m_9598_()).isEmpty() && variant < trophy.getVariants(level.m_9598_()).size()) {
                    CompoundTag tag = trophy.getVariants(level.m_9598_()).get(variant);
                    tag.m_128431_().forEach(s -> tooltip.add((Component)Component.m_237110_((String)"\"%s\": \"%s\"", (Object[])new Object[]{s, Objects.requireNonNull(tag.m_128423_(s)).m_7916_()}).m_130940_(ChatFormatting.GRAY)));
                }
            }
        }
    }

    private String getModIdForTooltip(String modId) {
        return ModList.get().getModContainerById(modId).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElseGet(() -> StringUtils.capitalize((String)modId));
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot slot, Entity entity) {
        return slot == EquipmentSlot.HEAD;
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new TrophyItemRenderer();
            }
        });
    }
}

