/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.trophy;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.gizmo.trophies.SyncTrophyConfigsPacket;
import com.gizmo.trophies.TrophyNetworkHandler;
import com.gizmo.trophies.behavior.CustomBehavior;
import com.gizmo.trophies.behavior.CustomTrophyBehaviors;
import com.gizmo.trophies.trophy.TrophyReloadListener;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public record Trophy(EntityType<?> type, double dropChance, double verticalOffset, float scale, Optional<CustomBehavior> clickBehavior, Either<Pair<String, ResourceLocation>, List<CompoundTag>> variants, Optional<CompoundTag> defaultData) {
    public static final Codec<Trophy> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ForgeRegistries.ENTITY_TYPES.getCodec().fieldOf("entity").forGetter(Trophy::type), (App)Codec.DOUBLE.optionalFieldOf("drop_chance", (Object)0.001).forGetter(Trophy::dropChance), (App)Codec.DOUBLE.optionalFieldOf("offset", (Object)0.0).forGetter(Trophy::verticalOffset), (App)Codec.FLOAT.optionalFieldOf("scale", (Object)Float.valueOf(1.0f)).forGetter(Trophy::scale), (App)CustomTrophyBehaviors.CODEC.optionalFieldOf("behavior").forGetter(Trophy::clickBehavior), (App)Codec.either((Codec)Codec.pair((Codec)Codec.STRING.fieldOf("key").codec(), (Codec)ResourceLocation.f_135803_.fieldOf("registry").codec()), (Codec)CompoundTag.f_128325_.listOf()).optionalFieldOf("variants", (Object)Either.right(new ArrayList())).forGetter(Trophy::variants), (App)CompoundTag.f_128325_.optionalFieldOf("default_variant").forGetter(Trophy::defaultData)).apply((Applicative)instance, Trophy::new));

    public static void reloadTrophies(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new TrophyReloadListener());
    }

    public static void syncTrophiesToClient(OnDatapackSyncEvent event) {
        if (FMLEnvironment.dist.isDedicatedServer()) {
            if (event.getPlayer() != null) {
                TrophyNetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> ((OnDatapackSyncEvent)event).getPlayer()), (Object)new SyncTrophyConfigsPacket(Trophy.getTrophies()));
            } else {
                event.getPlayerList().m_11314_().forEach(player -> TrophyNetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncTrophyConfigsPacket(Trophy.getTrophies())));
            }
        }
    }

    public List<CompoundTag> getVariants(@Nullable RegistryAccess access) {
        if (this.variants.left().isPresent() && access != null) {
            ArrayList<CompoundTag> entries = new ArrayList<CompoundTag>();
            Pair registryVariant = (Pair)this.variants.left().get();
            Registry registry = access.m_175515_(ResourceKey.m_135788_((ResourceLocation)((ResourceLocation)registryVariant.getSecond())));
            for (Map.Entry entry : registry.m_6579_()) {
                try {
                    entries.add((CompoundTag)Util.m_137469_((Object)new CompoundTag(), tag -> tag.m_128359_((String)registryVariant.getFirst(), ((ResourceKey)entry.getKey()).m_135782_().toString())));
                }
                catch (ClassCastException e) {
                    OpenBlocksTrophies.LOGGER.error("Something went wrong when trying to fetch variants from a registry!");
                    e.printStackTrace();
                }
            }
            return entries;
        }
        return this.variants.right().orElse(new ArrayList());
    }

    public List<CompoundTag> getVariants(HolderLookup.Provider access) {
        if (this.variants.left().isPresent()) {
            ArrayList<CompoundTag> entries = new ArrayList<CompoundTag>();
            Pair registryVariant = (Pair)this.variants.left().get();
            HolderLookup.RegistryLookup registry = access.m_255025_(ResourceKey.m_135788_((ResourceLocation)((ResourceLocation)registryVariant.getSecond())));
            for (ResourceKey entry : registry.m_255209_().toList()) {
                try {
                    CompoundTag formattedTag = (CompoundTag)Util.m_137469_((Object)new CompoundTag(), tag -> tag.m_128359_((String)registryVariant.getFirst(), entry.m_135782_().toString()));
                    if (entries.contains(formattedTag)) continue;
                    entries.add(formattedTag);
                }
                catch (ClassCastException e) {
                    OpenBlocksTrophies.LOGGER.error("Something went wrong when trying to fetch variants from a registry!");
                    e.printStackTrace();
                }
            }
            return entries;
        }
        return this.variants.right().orElse(new ArrayList());
    }

    public static TreeMap<ResourceLocation, Trophy> getTrophies() {
        return TrophyReloadListener.getValidTrophies();
    }

    public static class Builder {
        private final EntityType<?> type;
        private double dropChance = 0.001;
        private double verticalOffset = 0.0;
        private float scale = 1.0f;
        @Nullable
        private CustomBehavior clickBehavior = null;
        @Nullable
        private Pair<String, ResourceLocation> registryVariant;
        private List<CompoundTag> variants = new ArrayList<CompoundTag>();
        @Nullable
        private CompoundTag defaultVariant = null;

        public Builder(EntityType<?> type) {
            this.type = type;
        }

        public Builder copyFrom(Trophy trophy) {
            this.dropChance = trophy.dropChance();
            this.verticalOffset = trophy.verticalOffset();
            this.scale = trophy.scale();
            this.clickBehavior = trophy.clickBehavior().orElse(null);
            this.registryVariant = trophy.variants().left().orElse(null);
            this.variants = trophy.variants().right().orElse(new ArrayList());
            this.defaultVariant = trophy.defaultData().orElse(null);
            return this;
        }

        public Builder setDropChance(double chance) {
            this.dropChance = chance;
            return this;
        }

        public Builder setVerticalOffset(double offset) {
            this.verticalOffset = offset;
            return this;
        }

        public Builder setScale(float scale) {
            this.scale = scale;
            return this;
        }

        public Builder setRightClickBehavior(CustomBehavior behavior) {
            this.clickBehavior = behavior;
            return this;
        }

        public Builder addVariant(String variantId, String value) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_(variantId, value);
            this.variants.add(tag);
            return this;
        }

        public Builder addVariant(String variantId, int value) {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_(variantId, value);
            this.variants.add(tag);
            return this;
        }

        public Builder addVariant(String variantId, float value) {
            CompoundTag tag = new CompoundTag();
            tag.m_128350_(variantId, value);
            this.variants.add(tag);
            return this;
        }

        public Builder addVariant(String variantId, double value) {
            CompoundTag tag = new CompoundTag();
            tag.m_128347_(variantId, value);
            this.variants.add(tag);
            return this;
        }

        public Builder addVariant(String variantId, boolean value) {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_(variantId, value);
            this.variants.add(tag);
            return this;
        }

        public Builder addVariant(CompoundTag variant) {
            this.variants.add(variant);
            return this;
        }

        public Builder addVariants(List<CompoundTag> variant) {
            this.variants.addAll(variant);
            return this;
        }

        public Builder addRegistryVariant(String key, ResourceLocation registryName) {
            this.registryVariant = Pair.of((Object)key, (Object)registryName);
            return this;
        }

        public Builder addDefaultVariant(CompoundTag variant) {
            this.defaultVariant = variant;
            return this;
        }

        public Trophy build() {
            return new Trophy(this.type, this.dropChance, this.verticalOffset, this.scale, Optional.ofNullable(this.clickBehavior), (Either<Pair<String, ResourceLocation>, List<CompoundTag>>)(this.registryVariant != null ? Either.left(this.registryVariant) : Either.right(this.variants)), Optional.ofNullable(this.defaultVariant));
        }
    }
}

