/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.trophy;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.gizmo.trophies.trophy.Trophy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Logger;

public class TrophyReloadListener
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final TreeMap<ResourceLocation, Trophy> validTrophies = new TreeMap();

    public TrophyReloadListener() {
        super(GSON, "trophies");
    }

    public static TreeMap<ResourceLocation, Trophy> getValidTrophies() {
        return validTrophies;
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller profiler) {
        validTrophies.clear();
        map.forEach((resourceLocation, jsonElement) -> {
            if (ModList.get().isLoaded(resourceLocation.m_135827_())) {
                try {
                    Trophy trophy = (Trophy)Trophy.CODEC.parse((DynamicOps)JsonOps.INSTANCE, jsonElement).resultOrPartial(arg_0 -> ((Logger)OpenBlocksTrophies.LOGGER).error(arg_0)).orElseThrow();
                    ResourceLocation mob = ForgeRegistries.ENTITY_TYPES.getKey(trophy.type());
                    if (validTrophies.containsKey(mob)) {
                        Trophy existing = validTrophies.get(mob);
                        Trophy combinedTrophy = new Trophy.Builder(existing.type()).copyFrom(existing).addVariants(trophy.variants().right().orElse(new ArrayList())).build();
                        validTrophies.put(ForgeRegistries.ENTITY_TYPES.getKey(combinedTrophy.type()), combinedTrophy);
                    } else if (ForgeRegistries.ENTITY_TYPES.containsValue(trophy.type())) {
                        validTrophies.put(mob, trophy);
                    }
                }
                catch (Exception exception) {
                    OpenBlocksTrophies.LOGGER.error("Caught an error loading trophy config for {}! {}", resourceLocation, (Object)exception.getMessage());
                }
            }
        });
        OpenBlocksTrophies.LOGGER.info("Loaded {} Trophy configs.", (Object)validTrophies.size());
    }
}

