/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies;

import com.gizmo.trophies.Registries;
import com.gizmo.trophies.TrophyConfig;
import com.gizmo.trophies.TrophyNetworkHandler;
import com.gizmo.trophies.trophy.Trophy;
import com.gizmo.trophies.trophy.behaviors.CustomBehaviorRegistry;
import com.gizmo.trophies.trophy.behaviors.ElderGuardianCurseBehavior;
import com.gizmo.trophies.trophy.behaviors.ExplosionBehavior;
import com.gizmo.trophies.trophy.behaviors.ItemDropBehavior;
import com.gizmo.trophies.trophy.behaviors.MobEffectBehavior;
import com.gizmo.trophies.trophy.behaviors.PlaceBlockBehavior;
import com.gizmo.trophies.trophy.behaviors.PlayerSetFireBehavior;
import com.gizmo.trophies.trophy.behaviors.ShootArrowBehavior;
import com.gizmo.trophies.trophy.behaviors.ShootEnderPearlBehavior;
import com.gizmo.trophies.trophy.behaviors.ShootLlamaSpitBehavior;
import com.gizmo.trophies.trophy.behaviors.TotemOfUndyingEffectBehavior;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="obtrophies")
public class OpenBlocksTrophies {
    public static final String MODID = "obtrophies";
    public static final Logger LOGGER = LogManager.getLogger((String)"obtrophies");
    public static final Random TROPHY_RANDOM = new Random();
    public static final CreativeModeTab TROPHY_TAB = new CreativeModeTab("obtrophies"){
        private List<String> keys = new ArrayList<String>();

        public ItemStack m_6976_() {
            if (this.keys.isEmpty() && !Trophy.getTrophies().isEmpty()) {
                this.keys = new ArrayList<String>(Trophy.getTrophies().keySet().stream().map(ResourceLocation::toString).collect(Collectors.toList()));
            }
            ItemStack stack = new ItemStack((ItemLike)Registries.TROPHY_ITEM.get());
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("entity", this.keys.get(TROPHY_RANDOM.nextInt(this.keys.size())));
            stack.m_41700_("BlockEntityTag", (Tag)tag);
            return stack;
        }

        public ItemStack m_40787_() {
            this.m_6976_();
            ItemStack stack = new ItemStack((ItemLike)Registries.TROPHY_ITEM.get());
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("entity", this.keys.get((int)(Minecraft.m_91087_().f_91073_.m_46467_() / 20L % (long)this.keys.size())));
            stack.m_41700_("BlockEntityTag", (Tag)tag);
            return stack;
        }
    };

    public OpenBlocksTrophies() {
        Pair specPair = new ForgeConfigSpec.Builder().configure(TrophyConfig.CommonConfig::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)specPair.getRight());
        TrophyConfig.COMMON_CONFIG = (TrophyConfig.CommonConfig)specPair.getLeft();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(this::maybeDropTrophy);
        MinecraftForge.EVENT_BUS.addListener(Trophy::reloadTrophies);
        MinecraftForge.EVENT_BUS.addListener(Trophy::syncTrophiesToClient);
        Registries.BLOCKS.register(bus);
        Registries.BLOCK_ENTITIES.register(bus);
        Registries.ITEMS.register(bus);
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MODID, path);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            CustomBehaviorRegistry.registerBehavior(new MobEffectBehavior());
            CustomBehaviorRegistry.registerBehavior(new ItemDropBehavior());
            CustomBehaviorRegistry.registerBehavior(new ElderGuardianCurseBehavior());
            CustomBehaviorRegistry.registerBehavior(new ExplosionBehavior());
            CustomBehaviorRegistry.registerBehavior(new PlaceBlockBehavior());
            CustomBehaviorRegistry.registerBehavior(new PlayerSetFireBehavior());
            CustomBehaviorRegistry.registerBehavior(new ShootArrowBehavior());
            CustomBehaviorRegistry.registerBehavior(new ShootEnderPearlBehavior());
            CustomBehaviorRegistry.registerBehavior(new ShootLlamaSpitBehavior());
            CustomBehaviorRegistry.registerBehavior(new TotemOfUndyingEffectBehavior());
        });
        TrophyNetworkHandler.init();
    }

    public void maybeDropTrophy(LivingDropsEvent event) {
        Trophy trophy;
        if (!(event.getSource().m_7639_() instanceof Player) && !((Boolean)TrophyConfig.COMMON_CONFIG.anySourceDropsTrophies.get()).booleanValue()) {
            return;
        }
        if (event.getSource().m_7639_() instanceof FakePlayer && !((Boolean)TrophyConfig.COMMON_CONFIG.fakePlayersDropTrophies.get()).booleanValue()) {
            return;
        }
        if (Trophy.getTrophies().containsKey(ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)event.getEntity().m_6095_())) && (trophy = Trophy.getTrophies().get(ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)event.getEntity().m_6095_()))) != null) {
            double trophyDropChance = (Double)TrophyConfig.COMMON_CONFIG.dropChanceOverride.get() >= 0.0 ? ((Double)TrophyConfig.COMMON_CONFIG.dropChanceOverride.get()).doubleValue() : trophy.dropChance();
            double chance = ((double)event.getLootingLevel() + TROPHY_RANDOM.nextDouble() / 4.0) * trophyDropChance - TROPHY_RANDOM.nextDouble();
            if (chance > 0.0) {
                ItemStack stack = new ItemStack((ItemLike)Registries.TROPHY_ITEM.get());
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("entity", ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)event.getEntity().m_6095_()).toString());
                stack.m_41700_("BlockEntityTag", (Tag)tag);
                event.getDrops().add(new ItemEntity(event.getEntity().m_183503_(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), stack));
            }
        }
    }
}

