/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.client;

import com.gizmo.trophies.Registries;
import com.gizmo.trophies.block.TrophyBlock;
import com.gizmo.trophies.client.TrophyExtraRendering;
import com.gizmo.trophies.client.TrophyRenderer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import twilightforest.entity.TFEntities;
import twilightforest.entity.boss.KnightPhantom;
import twilightforest.entity.monster.ArmoredGiant;
import twilightforest.entity.monster.SnowGuardian;
import twilightforest.item.TFItems;

@Mod.EventBusSubscriber(modid="obtrophies", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientEvents {
    @SubscribeEvent
    public static void registerBERenderer(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)Registries.TROPHY_BE.get(), TrophyRenderer::new);
    }

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            TrophyExtraRendering.addExtraRenderForEntity(EntityType.f_20530_, entity -> {
                ZombieVillager villager = (ZombieVillager)entity;
                villager.m_141967_(villager.m_7141_().m_35565_(VillagerProfession.f_35585_));
            });
            TrophyExtraRendering.addExtraRenderForEntity(EntityType.f_20489_, entity -> {
                TropicalFish fish = (TropicalFish)entity;
                fish.m_30056_(ClientEvents.calculateVariant(TropicalFish.Pattern.KOB, DyeColor.ORANGE, DyeColor.WHITE));
            });
            if (ModList.get().isLoaded("twilightforest")) {
                TrophyExtraRendering.addExtraRenderForEntity((EntityType)TFEntities.ARMORED_GIANT.get(), entity -> {
                    ArmoredGiant giant = (ArmoredGiant)entity;
                    giant.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42468_));
                    giant.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42469_));
                    giant.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42470_));
                    giant.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42471_));
                });
                TrophyExtraRendering.addExtraRenderForEntity((EntityType)TFEntities.KNIGHT_PHANTOM.get(), entity -> {
                    KnightPhantom phantom = (KnightPhantom)entity;
                    phantom.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)TFItems.PHANTOM_HELMET.get()));
                    phantom.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)TFItems.PHANTOM_CHESTPLATE.get()));
                });
                TrophyExtraRendering.addExtraRenderForEntity((EntityType)TFEntities.SNOW_GUARDIAN.get(), entity -> {
                    SnowGuardian guardian = (SnowGuardian)entity;
                    guardian.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)TFItems.ARCTIC_HELMET.get()));
                    guardian.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)TFItems.ARCTIC_CHESTPLATE.get()));
                });
            }
        });
    }

    private static int calculateVariant(TropicalFish.Pattern pattern, DyeColor base, DyeColor accent) {
        return pattern.m_30088_() & 0xFF | (pattern.m_30092_() & 0xFF) << 8 | (base.m_41060_() & 0xFF) << 16 | (accent.m_41060_() & 0xFF) << 24;
    }

    @Mod.EventBusSubscriber(modid="obtrophies", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeClientEvents {
        @SubscribeEvent
        public static void dontRenderTrophyHitbox(DrawSelectionEvent.HighlightBlock event) {
            BlockState state = event.getCamera().m_90592_().f_19853_.m_8055_(event.getTarget().m_82425_());
            if (state.m_60713_((Block)Registries.TROPHY.get()) && !((Boolean)state.m_61143_((Property)TrophyBlock.PEDESTAL)).booleanValue()) {
                event.setCanceled(true);
            }
        }
    }
}

