/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.data;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.gizmo.trophies.trophy.Trophy;
import com.gizmo.trophies.trophy.TrophyReloadListener;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class TrophyProvider
implements DataProvider {
    protected final Map<ResourceLocation, Trophy> builder = Maps.newLinkedHashMap();
    private final DataGenerator generator;
    private final String modid;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public TrophyProvider(DataGenerator generator, String modid) {
        this.modid = modid;
        this.generator = generator;
    }

    public void m_6865_(HashCache output) {
        HashMap map = Maps.newHashMap();
        this.builder.clear();
        this.createTrophies();
        map.putAll(this.builder);
        map.forEach((resourceLocation, trophy) -> {
            Path path = this.generator.m_123916_().resolve("data/" + this.modid + "/trophies/" + resourceLocation.m_135815_() + ".json");
            try {
                String s = GSON.toJson(TrophyReloadListener.serialize(trophy));
                String s1 = f_123918_.hashUnencodedChars((CharSequence)s).toString();
                if (!Objects.equals(output.m_123938_(path), s1) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                        bufferedwriter.write(s);
                    }
                }
                output.m_123940_(path, s1);
            }
            catch (IOException ioexception) {
                OpenBlocksTrophies.LOGGER.error("Couldn't save trophy entry {}", (Object)path, (Object)ioexception);
            }
        });
    }

    protected abstract void createTrophies();

    protected void makeTrophy(Trophy trophy) {
        this.builder.putIfAbsent(new ResourceLocation(this.modid, Objects.requireNonNull(ForgeRegistries.ENTITIES.getKey(trophy.type())).m_135815_()), trophy);
    }

    public String m_6055_() {
        return this.modid + " Trophies";
    }
}

