/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.item;

import com.gizmo.trophies.client.TrophyItemRenderer;
import com.gizmo.trophies.trophy.Trophy;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;

public class TrophyItem
extends BlockItem {
    public static final String ENTITY_TAG = "entity";
    public static final String COOLDOWN_TAG = "cooldown";

    public TrophyItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @Nullable
    public static Trophy getTrophy(@Nonnull ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = BlockItem.m_186336_((ItemStack)stack)) != null && tag.m_128441_(ENTITY_TAG)) {
            String entityKey = tag.m_128461_(ENTITY_TAG);
            if (Trophy.getTrophies().containsKey(ResourceLocation.m_135820_((String)entityKey))) {
                return Trophy.getTrophies().get(ResourceLocation.m_135820_((String)entityKey));
            }
        }
        return null;
    }

    public Component m_7626_(ItemStack stack) {
        Trophy trophy = TrophyItem.getTrophy(stack);
        if (trophy != null) {
            return new TranslatableComponent("block.obtrophies.trophy.entity", new Object[]{trophy.type().m_20676_().getString()});
        }
        return super.m_7626_(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        Trophy trophy = TrophyItem.getTrophy(stack);
        if (trophy != null) {
            TranslatableComponent attempted;
            String untranslated = "item.obtrophies.trophy.modid." + Objects.requireNonNull(ForgeRegistries.ENTITIES.getKey(trophy.type())).m_135827_();
            if (untranslated.equals((attempted = new TranslatableComponent(untranslated)).getString())) {
                tooltip.add((Component)new TranslatableComponent("item.obtrophies.trophy.modid", new Object[]{WordUtils.capitalize((String)Objects.requireNonNull(ForgeRegistries.ENTITIES.getKey(trophy.type())).m_135827_().replace('_', ' '))}).m_130940_(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)new TranslatableComponent("item.obtrophies.trophy.modid", new Object[]{attempted.getString()}).m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot slot, Entity entity) {
        return slot == EquipmentSlot.HEAD;
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> stacks) {
        if (this.m_41389_(tab) && !Trophy.getTrophies().isEmpty()) {
            TreeMap sortedTrophies = new TreeMap(Comparator.naturalOrder());
            sortedTrophies.putAll(Trophy.getTrophies());
            for (Map.Entry trophyEntry : sortedTrophies.entrySet()) {
                ItemStack stack = new ItemStack((ItemLike)this);
                CompoundTag tag = new CompoundTag();
                tag.m_128359_(ENTITY_TAG, Objects.requireNonNull(ForgeRegistries.ENTITIES.getKey(((Trophy)trophyEntry.getValue()).type())).toString());
                stack.m_41700_("BlockEntityTag", (Tag)tag);
                stacks.add((Object)stack);
            }
        }
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return new TrophyItemRenderer();
            }
        });
    }
}

