/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.trophy;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.gizmo.trophies.SyncTrophyConfigsPacket;
import com.gizmo.trophies.TrophyNetworkHandler;
import com.gizmo.trophies.trophy.TrophyReloadListener;
import com.gizmo.trophies.trophy.behaviors.CustomBehavior;
import com.gizmo.trophies.trophy.behaviors.CustomBehaviorRegistry;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public record Trophy(EntityType<?> type, double dropChance, double verticalOffset, float scale, @Nullable CustomBehavior behavior) {
    public Trophy(EntityType<?> type) {
        this(type, 0.001, 0.0, 1.0f, null);
    }

    public Trophy(EntityType<?> type, CustomBehavior behavior) {
        this(type, 0.001, 0.0, 1.0f, behavior);
    }

    public Trophy(EntityType<?> type, double verticalOffset, float scale) {
        this(type, 0.001, verticalOffset, scale, null);
    }

    public Trophy(EntityType<?> type, double verticalOffset, float scale, CustomBehavior behavior) {
        this(type, 0.001, verticalOffset, scale, behavior);
    }

    public static void reloadTrophies(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new TrophyReloadListener());
    }

    public static void syncTrophiesToClient(OnDatapackSyncEvent event) {
        if (FMLEnvironment.dist.isDedicatedServer()) {
            if (event.getPlayer() != null) {
                TrophyNetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> ((OnDatapackSyncEvent)event).getPlayer()), (Object)new SyncTrophyConfigsPacket(Trophy.getTrophies()));
            } else {
                event.getPlayerList().m_11314_().forEach(player -> TrophyNetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncTrophyConfigsPacket(Trophy.getTrophies())));
            }
        }
    }

    public static Map<ResourceLocation, Trophy> getTrophies() {
        return TrophyReloadListener.getValidTrophies();
    }

    public static Trophy fromJson(JsonObject object) {
        String entityType = GsonHelper.m_13906_((JsonObject)object, (String)"entity");
        if (ForgeRegistries.ENTITIES.getValue(ResourceLocation.m_135820_((String)entityType)) == null) {
            throw new JsonParseException("Entity" + entityType + " defined in Trophy config does not exist!");
        }
        EntityType realEntity = (EntityType)ForgeRegistries.ENTITIES.getValue(ResourceLocation.m_135820_((String)entityType));
        double dropChance = GsonHelper.m_144742_((JsonObject)object, (String)"drop_chance", (double)0.001);
        double verticalOffset = GsonHelper.m_144742_((JsonObject)object, (String)"offset", (double)0.0);
        float scale = GsonHelper.m_13820_((JsonObject)object, (String)"scale", (float)1.0f);
        CustomBehavior behavior = null;
        if (object.has("behavior")) {
            try {
                JsonObject bObject = GsonHelper.m_13918_((JsonElement)object.get("behavior"), (String)"behavior");
                CustomBehavior fetchedBehavior = CustomBehaviorRegistry.getBehavior(Objects.requireNonNull(ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)bObject, (String)"type"))));
                behavior = fetchedBehavior.fromJson(bObject);
            }
            catch (Exception e) {
                OpenBlocksTrophies.LOGGER.error("Could not fetch custom behavior for trophy {}, setting to null", (Object)entityType, (Object)e);
            }
        }
        return new Trophy(realEntity, dropChance, verticalOffset, scale, behavior);
    }

    public static Trophy fromNetwork(FriendlyByteBuf buf) {
        return new Trophy((EntityType)buf.readRegistryId(), buf.readDouble(), buf.readDouble(), buf.readFloat(), null);
    }

    public void toNetwork(FriendlyByteBuf buf) {
        buf.writeRegistryIdUnsafe(ForgeRegistries.ENTITIES, this.type());
        buf.writeDouble(this.dropChance());
        buf.writeDouble(this.verticalOffset());
        buf.writeFloat(this.scale());
    }

    public static class Serializer
    implements JsonSerializer<Trophy>,
    JsonDeserializer<Trophy> {
        public Trophy deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = GsonHelper.m_13918_((JsonElement)json, (String)"trophy");
            return Trophy.fromJson(object);
        }

        public JsonElement serialize(Trophy trophy, Type type, JsonSerializationContext context) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.add("entity", context.serialize((Object)Objects.requireNonNull(ForgeRegistries.ENTITIES.getKey(trophy.type())).toString()));
            jsonobject.add("drop_chance", context.serialize((Object)trophy.dropChance()));
            jsonobject.add("offset", context.serialize((Object)trophy.verticalOffset()));
            jsonobject.add("scale", context.serialize((Object)Float.valueOf(trophy.scale())));
            if (trophy.behavior() != null) {
                jsonobject.add("behavior", (JsonElement)trophy.behavior().serializeBehavior(context));
            }
            return jsonobject;
        }
    }
}

